/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.authority;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class InvertedHeartAuthority
extends GeasEffect {
    public WeakHashMap<UUID, LivingEntity> visibleTargets = new WeakHashMap();

    public InvertedHeartAuthority() {
        super((GeasEffectType)MalumGeasEffectTypes.AUTHORITY_OF_THE_INVERTED_HEART.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("inverted_heart", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("inverted_heart_arcane_resonance", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        this.addAttributeModifier(modifiers, (Holder<Attribute>)LodestoneAttributes.MAGIC_RESISTANCE, -0.75, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        return modifiers;
    }

    public void finalizedIncomingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.getSource().is(MalumTags.DamageTypeTags.INVERTED_HEART_RETALIATION_BLACKLIST)) {
            return;
        }
        this.damageTargets(target, null, MalumDamageTypes.INVERTED_HEART_RETALIATION, event.getOriginalDamage());
    }

    public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.getSource().is(MalumTags.DamageTypeTags.INVERTED_HEART_PROPAGATION_BLACKLIST)) {
            return;
        }
        if (!attacker.equals((Object)event.getSource().getEntity())) {
            return;
        }
        float damage = event.getNewDamage() / 2.0f;
        this.damageTargets(attacker, target, MalumDamageTypes.INVERTED_HEART_PROPAGATION, damage);
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        Entity geasHolder = event.getEntity();
        Level level = geasHolder.level();
        if (level.getGameTime() % 40L == 0L) {
            this.visibleTargets.clear();
            double influence = 8.0;
            for (LivingEntity target : level.getEntitiesOfClass(LivingEntity.class, geasHolder.getBoundingBox().inflate((influence *= entity.getAttributeValue(MalumAttributes.ARCANE_RESONANCE)) * 2.0, influence, influence * 2.0))) {
                TamableAnimal tamableAnimal;
                Player player;
                if (target == geasHolder || target.isSpectator() || target instanceof Player && geasHolder.isInvisibleTo(player = (Player)target) || target.getTeam() != null && target.getTeam().isAlliedTo((Team)geasHolder.getTeam()) && !target.getTeam().isAllowFriendlyFire() || target instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)target).isTame() || target.hasCustomName() || !this.hasLineOfSight(geasHolder, (Entity)target)) continue;
                this.visibleTargets.put(target.getUUID(), target);
            }
        }
    }

    public void damageTargets(LivingEntity wrathBearer, @Nullable LivingEntity excludedTarget, ResourceKey<DamageType> damageType, float damage) {
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>(this.visibleTargets.values());
        Collections.shuffle(targets);
        for (int i = 0; i < targets.size(); ++i) {
            LivingEntity target = targets.get(i);
            if (target.equals((Object)excludedTarget) || !target.isAlive()) continue;
            MalumNetworkedParticleEffectColorData color = new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.WICKED_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT);
            WorldEventHandler.addWorldEvent((Level)target.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setMagicDamageType(damageType).setImpactParticleEffect(MalumParticleEffectTypes.INVERTED_HEART_IMPACT, color).setSound((Holder<SoundEvent>)MalumSoundEvents.INVERTED_HEART_IMPACT, 1.0f, 2.0f, 0.5f).setAttacker((Entity)wrathBearer).setDamageData(0.0f, damage, 8 + i * 2));
        }
    }

    public boolean hasLineOfSight(Entity wrathBearer, Entity target) {
        Vec3 wrathPosition = new Vec3(wrathBearer.getX(), wrathBearer.getEyeY(), wrathBearer.getZ());
        Vec3 targetPosition = new Vec3(target.getX(), target.getEyeY(), target.getZ());
        BlockHitResult clipResult = wrathBearer.level().clip(new ClipContext(wrathPosition, targetPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, wrathBearer));
        return clipResult.getType().equals((Object)HitResult.Type.MISS);
    }
}

