/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.oath.deliverance;

import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.MalignantCritEvent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class UnmakersDisdainGeas
extends GeasEffect {
    public UnmakersDisdainGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.OATH_OF_UNMAKERS_DISDAIN.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("malignant_crit_combo", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("malignant_crit_health_condition", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    @Override
    public void malignantCritEvent(MalignantCritEvent.Pre event, LivingEntity attacker) {
        float health = attacker.getHealth() / attacker.getMaxHealth();
        if (health <= 0.8f) {
            event.setCanceled(true);
        }
    }

    @Override
    public void finalizedMalignantCritEvent(MalignantCritEvent.Post event, LivingEntity attacker) {
        Level level = event.getLivingEntity().level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            DamageSource source = event.getSource();
            LivingEntity target = event.getLivingEntity();
            if (source.is(MalumDamageTypes.UNMAKERS_DISDAIN_COMBO)) {
                WeaponParticleEffectType.WeaponParticleEffectBuilder particle = MalumParticleEffectTypes.SCYTHE_SLASH.createEffect().targets((Entity)target).originatesFrom((Entity)attacker).tiedToTarget();
                if (SoulDataHandler.getScytheWeapon(source, attacker).isEmpty() || !MalumScytheItem.canSweep(attacker)) {
                    particle.verticalSlashRotation();
                }
                particle.spawn(level2);
                return;
            }
            RandomSource random = target.getRandom();
            int extraHits = random.nextInt(4, 6);
            float damage = (float)attacker.getAttribute(Attributes.ATTACK_DAMAGE).getValue() / (float)extraHits * 0.5f;
            for (int i = 0; i < extraHits; ++i) {
                int delay = 4 + i;
                WorldEventHandler.addWorldEvent((Level)target.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker, source.getDirectEntity()).setDamageData(damage, 0.0f, delay).setPhysicalDamageType(MalumDamageTypes.UNMAKERS_DISDAIN_COMBO).setSound((Holder<SoundEvent>)MalumSoundEvents.MALIGNANT_METAL_COMBO, 0.5f, 1.5f, 0.3f));
            }
        }
    }
}

