/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.aqueous;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class TidalAffinityGeas
extends GeasEffect {
    private boolean isInWater;
    private boolean hasConduitEffect;

    public TidalAffinityGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_TIDAL_AFFINITY.get());
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        if (this.isInWater) {
            float swimSpeed = this.hasConduitEffect ? 0.4f : 0.2f;
            float attackSpeed = this.hasConduitEffect ? 0.2f : 0.1f;
            this.addAttributeModifier(modifiers, (Holder<Attribute>)NeoForgeMod.SWIM_SPEED, swimSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.ATTACK_SPEED, attackSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.BLOCK_BREAK_SPEED, attackSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.SUBMERGED_MINING_SPEED, 4.0, AttributeModifier.Operation.ADD_VALUE);
            if (this.hasConduitEffect) {
                this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.HEALING_MULTIPLIER, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            }
        } else {
            this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.HEALING_MULTIPLIER, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
        return modifiers;
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("water_agility", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("water_damage_resistance", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("conduit_bonus", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("fish_healing", new Object[0]));
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        float damageScalar = 1.0f - (this.isInWater ? 0.25f : 0.0f) - (this.hasConduitEffect ? 0.25f : 0.0f);
        event.setNewDamage(event.getNewDamage() * damageScalar);
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (entity.level().getGameTime() % 10L == 0L) {
            boolean wasInWater = this.isInWater;
            boolean hadConduitEffect = this.hasConduitEffect;
            this.isInWater = entity.isInWaterOrRain();
            this.hasConduitEffect = entity.hasEffect(MobEffects.CONDUIT_POWER);
            if (this.isInWater && this.hasConduitEffect) {
                entity.heal(1.0f);
            }
            if (wasInWater != this.isInWater || hadConduitEffect != this.hasConduitEffect) {
                this.setDirty();
            }
        }
    }
}

