/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.infernal;

import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class CombustionGeas
extends GeasEffect {
    public CombustionGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_COMBUSTION.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("hotter_fire", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("extinguish_hurt", new Object[0]));
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.getSource().is(DamageTypeTags.IS_FIRE)) {
            target.setRemainingFireTicks(Math.max(target.getRemainingFireTicks() - 8, 0));
            target.invulnerableTime = 0;
            Level level = attacker.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                MalumParticleEffectTypes.COMBUSTION_BURN.createEffect((Entity)target).color(new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.INFERNAL_SPIRIT)).spawn(level2);
            }
        }
    }

    public static void extinguish(LivingEntity entity) {
        if (GeasEffectHandler.hasGeasEffect(entity, MalumGeasEffectTypes.PACT_OF_COMBUSTION) && entity.wasOnFire) {
            for (int i = 0; i < 3; ++i) {
                WorldEventHandler.addWorldEvent((Level)entity.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)entity).setDamageData(0.0f, 4.0f, (i + 1) * 2).setMagicDamageType(MalumDamageTypes.KARMIC).setImpactParticleEffect(MalumParticleEffectTypes.COMBUSTION_BURN, new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT)).setSound((Holder<SoundEvent>)MalumSoundEvents.COMBUSTION_WHIPLASH, 0.5f, 0.4f, 1.0f));
            }
        }
    }
}

