/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.infernal;

import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import team.lodestar.lodestone.helpers.EntityHelper;

public class PyromaniacGeas
extends GeasEffect {
    public PyromaniacGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_PYROMANIAC.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("explosion_lover", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("pyromaniac", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("explosion_resistance", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("explosion_fire", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("scary_fire", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.getSource().is(DamageTypeTags.IS_FIRE)) {
            event.setNewDamage(event.getNewDamage() * 2.0f);
        }
        if (event.getSource().is(DamageTypeTags.IS_EXPLOSION)) {
            float health = target.getHealth();
            event.setNewDamage(Mth.clamp((float)(event.getNewDamage() * 0.25f), (float)0.0f, (float)(health * 0.5f)));
        }
    }

    public static void processExplosion(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        for (Entity entity : event.getAffectedEntities()) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !explosion.damageCalculator.shouldDamageEntity(explosion, (Entity)(livingEntity = (LivingEntity)entity)) || !GeasEffectHandler.hasGeasEffect(livingEntity, MalumGeasEffectTypes.PACT_OF_THE_PYROMANIAC)) continue;
            PyromaniacGeas.applyPyromaniac(livingEntity, explosion);
        }
    }

    public static void applyPyromaniac(LivingEntity entity, Explosion explosion) {
        MobEffectInstance instance;
        int pyromaniacStacks = 2;
        if (!entity.equals((Object)explosion.getIndirectSourceEntity()) && !entity.equals((Object)explosion.getDirectSourceEntity())) {
            pyromaniacStacks = 4;
        }
        if ((instance = entity.getEffect(MalumMobEffects.PYROMANIACS_FERVOR)) != null) {
            if (instance.getAmplifier() >= 5) {
                entity.igniteForSeconds(5.0f);
            }
            EntityHelper.extendEffect((MobEffectInstance)instance, (LivingEntity)entity, (int)300, (int)1200);
            EntityHelper.amplifyEffect((MobEffectInstance)instance, (LivingEntity)entity, (int)pyromaniacStacks, (int)9);
        } else {
            entity.addEffect(new MobEffectInstance(MalumMobEffects.PYROMANIACS_FERVOR, 600, pyromaniacStacks - 1));
        }
    }
}

