/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.sacred;

import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.geas.LifeweaverHealingBeamParticleEffect;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class LifeweaverGeas
extends GeasEffect {
    public LifeweaverGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_LIFEWEAVER.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("passive_healing", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("healing_aura", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("healing_aura_no_filter", new Object[0]));
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (entity.level().getGameTime() % 40L == 0L) {
            entity.heal(1.0f);
        }
    }

    public static void onHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (GeasEffectHandler.hasGeasEffect(entity, MalumGeasEffectTypes.PACT_OF_THE_LIFEWEAVER)) {
                float horizontalRadius = 6.0f;
                float verticalRadius = 4.0f;
                AABB aabb = entity.getBoundingBox().inflate((double)horizontalRadius, (double)verticalRadius, (double)horizontalRadius);
                boolean success = false;
                for (LivingEntity target : level2.getEntitiesOfClass(LivingEntity.class, aabb)) {
                    if (target == entity || GeasEffectHandler.hasGeasEffect(target, MalumGeasEffectTypes.PACT_OF_THE_LIFEWEAVER)) continue;
                    float health = target.getHealth();
                    if (target.isInvertedHealAndHarm()) {
                        target.hurt(DamageTypeHelper.create((Level)level2, MalumDamageTypes.VOODOO, (Entity)entity), event.getAmount() * 2.0f);
                    } else {
                        target.heal(event.getAmount() * 1.5f);
                    }
                    if (health == target.getHealth()) continue;
                    MalumParticleEffectTypes.HEALING_BEAM.createEffect((Entity)entity).color(MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT).customData(new LifeweaverHealingBeamParticleEffect.LifeweaverHealingBeamEffectData(target.getId(), entity.getId())).spawn(level2);
                    success = true;
                }
                if (success) {
                    event.setAmount(event.getAmount() * 1.25f);
                }
            }
        }
    }
}

