/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.weeping;

import com.sammy.malum.common.data.attachment.CurioData;
import com.sammy.malum.common.entity.hidden_blade.HiddenBladeDelayedImpactEntity;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.common.packets.SyncCurioDataPayload;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;

public class CurioHiddenBladeNecklace
extends MalumCurioItem
implements IMalumEventResponder,
IVoidItem {
    public static final int COOLDOWN_DURATION = 200;

    public CurioHiddenBladeNecklace(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("scythe_counterattack", new Object[0]));
        consumer.accept(ComponentHelper.negativeCurioEffect("pacifist_recharge", new Object[0]));
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity attacked, ItemStack stack) {
        if (attacked.level().isClientSide()) {
            return;
        }
        if (((CurioData)attacked.getData(MalumAttachmentTypes.CURIO_DATA)).hiddenBladeNecklaceCooldown == 0) {
            float damage = event.getOriginalDamage();
            int amplifier = Math.min(Mth.floor((float)(damage / 4.0f)), 9);
            attacked.addEffect(new MobEffectInstance(MalumMobEffects.WICKED_INTENT, 80, amplifier));
            SoundHelper.playSound((Entity)attacked, (SoundEvent)((SoundEvent)MalumSoundEvents.HIDDEN_BLADE_PRIMED.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)attacked.level().getRandom(), (float)1.4f, (float)1.6f));
        }
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            DamageSource source = event.getSource();
            if (!source.is(MalumDamageTypes.SCYTHE_MELEE)) {
                return;
            }
            if (CurioHelper.hasCurioEquipped((LivingEntity)attacker, (Item)((Item)MalumItems.NECKLACE_OF_THE_HIDDEN_BLADE.get()))) {
                CurioData data = (CurioData)attacker.getData(MalumAttachmentTypes.CURIO_DATA);
                RandomSource random = level2.getRandom();
                if (data.hiddenBladeNecklaceCooldown != 0) {
                    if (data.hiddenBladeNecklaceCooldown <= 200) {
                        SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)MalumSoundEvents.HIDDEN_BLADE_DISRUPTED.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.7f, (float)0.8f));
                    }
                    data.hiddenBladeNecklaceCooldown = 300;
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)attacker, (CustomPacketPayload)new SyncCurioDataPayload(attacker.getId(), data), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return;
                }
                MobEffectInstance effect = attacker.getEffect(MalumMobEffects.WICKED_INTENT);
                if (effect == null) {
                    return;
                }
                ItemStack scytheWeapon = SoulDataHandler.getScytheWeapon(source, attacker);
                Vec3 direction = attacker.getLookAngle();
                Vec3 damageCenter = attacker.position().add(direction);
                AttributeMap attributes = attacker.getAttributes();
                float multiplier = 1.0f + (float)(effect.amplifier + 1) * 0.2f;
                int duration = 25;
                float physicalDamage = (float)((double)event.getNewDamage() + attributes.getValue(Attributes.ATTACK_DAMAGE)) / (float)duration * multiplier;
                float magicDamage = (float)(attributes.getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE) / (double)duration) * multiplier;
                HiddenBladeDelayedImpactEntity entity = new HiddenBladeDelayedImpactEntity((Level)level2, damageCenter.x, damageCenter.y - 3.0 + (double)(attacker.getBbHeight() / 2.0f), damageCenter.z);
                entity.setData((Entity)attacker, physicalDamage, magicDamage, duration);
                entity.setItem(scytheWeapon);
                level2.addFreshEntity((Entity)entity);
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)attacker, (CustomPacketPayload)new SyncCurioDataPayload(attacker.getId(), data), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (!effect.isInfiniteDuration()) {
                    data.hiddenBladeNecklaceCooldown = 200;
                    attacker.removeEffect(effect.getEffect());
                }
                for (int i = 0; i < 3; ++i) {
                    SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)MalumSoundEvents.HIDDEN_BLADE_UNLEASHED.get()), (float)3.0f, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.75f, (float)1.25f));
                }
                MalumParticleEffectTypes.HIDDEN_BLADE_COUNTER_FLURRY.createEffect().originatesFrom((Entity)attacker).aimedAt(direction).color(scytheWeapon.getItem()).mirroredRandomly(random).randomSlashRotation(random).spawn(level2);
                event.setNewDamage(0.0f);
            }
        }
    }

    public static void entityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            Level level = entity2.level();
            CurioData data = (CurioData)entity2.getData(MalumAttachmentTypes.CURIO_DATA);
            if (data.hiddenBladeNecklaceCooldown > 0) {
                --data.hiddenBladeNecklaceCooldown;
                if (!level.isClientSide() && data.hiddenBladeNecklaceCooldown == 0) {
                    SoundHelper.playSound((Entity)entity2, (SoundEvent)((SoundEvent)MalumSoundEvents.HIDDEN_BLADE_CHARGED.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)1.0f, (float)1.2f));
                }
            }
        }
    }
}

