/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.entity.SunderingAnchorProjectileEntity;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.TemporarilyDisabledItem;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.visual_effects.networked.attack.SunderingAnchorSlashParticleEffect;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.item.LodestoneCombatItem;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class SunderingAnchorItem
extends LodestoneCombatItem
implements IMalumEventResponder,
ISpiritAffiliatedItem {
    public static final MalumSpiritType[] SPIRITS = new MalumSpiritType[]{MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT};

    public static MalumSpiritType getSunderingAnchorSpirit() {
        return SPIRITS[MalumMod.RANDOM.nextInt(SPIRITS.length)];
    }

    public SunderingAnchorItem(Tier tier, float magicDamage, LodestoneItemProperties properties) {
        super(tier, -2.0f, -2.0f, properties.component(DataComponents.TOOL, (Object)SunderingAnchorItem.createToolProperties(tier, MalumTags.BlockTags.MINEABLE_WITH_KNIFE)).mergeAttributes(ItemAttributeModifiers.builder().add((Holder)LodestoneAttributes.MAGIC_DAMAGE, new AttributeModifier(LodestoneAttributes.MAGIC_DAMAGE.getId(), (double)magicDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect("sundering_anchor_damage_split", new Object[0])});
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect("sundering_anchor_hatred", new Object[0])});
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.equals((Object)Enchantments.BREACH)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    @Override
    public MalumSpiritType getDefiningSpiritType() {
        return SunderingAnchorItem.getSunderingAnchorSpirit();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        BlockHitResult blockHitResult;
        ItemStack stack = player.getItemInHand(usedHand);
        HitResult hitResult = EntityHelper.pick((LivingEntity)player);
        if (hitResult instanceof BlockHitResult && level.getBlockState((blockHitResult = (BlockHitResult)hitResult).getBlockPos()).is(MalumTags.BlockTags.SUNDERING_ANCHOR_KNIFE_BEHAVIOR)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int slot = usedHand == InteractionHand.OFF_HAND ? player.getInventory().getContainerSize() - 1 : player.getInventory().selected;
            float physicalDamage = (float)player.getAttributes().getValue(Attributes.ATTACK_DAMAGE);
            float magicDamage = (float)player.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
            Vec3 pos = this.getProjectileSpawnPos((LivingEntity)player, usedHand, 0.5f, 0.5f);
            SunderingAnchorProjectileEntity entity = new SunderingAnchorProjectileEntity(level, pos.x, pos.y, pos.z);
            entity.setData((LivingEntity)player, physicalDamage, magicDamage, slot);
            entity.setItem(stack);
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 0.0f);
            level.addFreshEntity((Entity)entity);
            SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)MalumSoundEvents.SUNDERING_ANCHOR_THROW.get()), (float)0.5f, (float)RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)1.5f, (float)2.0f));
            TemporarilyDisabledItem.disable(serverPlayer, slot, MalumItems.SOUL_OF_THE_ANCHOR);
            SunderingAnchorItem.applyCooldown(stack, player);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            DamageSource source = event.getSource();
            RandomSource random = level2.random;
            if (source.is(LodestoneDamageTypeTags.IS_MAGIC)) {
                SunderingAnchorItem.applyHatred(target);
            }
            if (source.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) {
                int slashCount = 3 + Mth.floor((float)(random.nextFloat() * 3.0f));
                float splitDamage = event.getNewDamage() / (float)slashCount;
                if (target.isAlive()) {
                    for (int i = 0; i < slashCount; ++i) {
                        WorldEventHandler.addWorldEvent((Level)level2, (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker).setDamageData(0.0f, splitDamage, i * 2).setPhysicalDamageType(MalumDamageTypes.SUNDERING_ANCHOR_PHYSICAL_COMBO).setMagicDamageType(MalumDamageTypes.SUNDERING_ANCHOR_MAGIC_COMBO).setSound((Holder<SoundEvent>)MalumSoundEvents.SUNDERING_ANCHOR_EXTRA_SWING, 1.2f, 1.4f, 0.7f));
                    }
                }
                event.setNewDamage(splitDamage);
                float pitch = RandomHelper.randomBetween((RandomSource)level2.getRandom(), (float)1.0f, (float)1.2f);
                SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)MalumSoundEvents.SUNDERING_ANCHOR_SWING.get()), (float)2.0f, (float)pitch);
                MalumParticleEffectTypes.SUNDERING_ANCHOR_SLASH.createEffect().originatesFrom((Entity)attacker).forwardOffset(1.5f).horizontalOffset(0.3f).upwardOffset(-0.2f).color(SPIRITS).customData(new SunderingAnchorSlashParticleEffect.SunderingAnchorSlashEffectData(slashCount)).randomSlashRotation(random).spawn(level2);
            }
        }
    }

    public static void applyCooldown(ItemStack stack, Player player) {
        if (!player.isCreative()) {
            int cooldown = 200;
            player.getCooldowns().addCooldown(stack.getItem(), cooldown);
        }
    }

    public static void applyHatred(LivingEntity target) {
        DeferredHolder<MobEffect, MobEffect> hatred = MalumMobEffects.HATRED;
        MobEffectInstance effect = target.getEffect(hatred);
        if (effect == null) {
            target.addEffect(new MobEffectInstance(hatred, 120, 0, true, true, true));
        } else {
            EntityHelper.amplifyEffect((MobEffectInstance)effect, (LivingEntity)target, (int)1, (int)49);
            EntityHelper.extendEffect((MobEffectInstance)effect, (LivingEntity)target, (int)60, (int)3000);
        }
    }

    public static Tool createToolProperties(Tier tier, TagKey<Block> blocks) {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f), Tool.Rule.deniesDrops((TagKey)tier.getIncorrectBlocksForDrops()), Tool.Rule.minesAndDrops(blocks, (float)tier.getSpeed())), 1.0f, 2);
    }

    public Vec3 getProjectileSpawnPos(LivingEntity player, InteractionHand hand, float distance, float spread) {
        int angle = hand == InteractionHand.MAIN_HAND ? 225 : 90;
        double radians = Math.toRadians((float)angle - player.yHeadRot);
        return player.position().add(player.getLookAngle().scale((double)distance)).add((double)spread * Math.sin(radians), (double)(player.getBbHeight() * 0.9f), (double)spread * Math.cos(radians));
    }
}

