/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets;

import com.sammy.malum.common.data.attachment.CurioData;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import team.lodestar.lodestone.systems.network.OneSidedPayloadData;

public class SyncCurioDataPayload
extends OneSidedPayloadData {
    private final int entityId;
    private final CurioData data;

    public SyncCurioDataPayload(int entityId, CurioData data) {
        this.entityId = entityId;
        this.data = data;
    }

    public SyncCurioDataPayload(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.data = (CurioData)CurioData.STREAM_CODEC.decode((Object)buf);
    }

    public void handle(IPayloadContext context) {
        Entity entity = context.player().level().getEntity(this.entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.setData(MalumAttachmentTypes.CURIO_DATA, (Object)this.data);
        }
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        CurioData.STREAM_CODEC.encode((Object)buf, (Object)this.data);
    }
}

