/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets;

import com.sammy.malum.common.data.attachment.SoulWardData;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import team.lodestar.lodestone.systems.network.OneSidedPayloadData;

public class SyncSoulWardDataPayload
extends OneSidedPayloadData {
    private final int entityId;
    private final SoulWardData data;

    public SyncSoulWardDataPayload(int entityId, SoulWardData data) {
        this.entityId = entityId;
        this.data = data;
    }

    public SyncSoulWardDataPayload(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.data = (SoulWardData)SoulWardData.STREAM_CODEC.decode((Object)buf);
    }

    public void handle(IPayloadContext context) {
        Entity entity = context.player().level().getEntity(this.entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.setData(MalumAttachmentTypes.SOUL_WARD, (Object)this.data);
        }
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        SoulWardData.STREAM_CODEC.encode((Object)buf, (Object)this.data);
    }
}

