/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets;

import com.sammy.malum.common.data.attachment.StaffAbilityData;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import team.lodestar.lodestone.systems.network.OneSidedPayloadData;

public class SyncStaffAbilityDataPayload
extends OneSidedPayloadData {
    private final int entityId;
    private final StaffAbilityData data;

    public SyncStaffAbilityDataPayload(int entityId, StaffAbilityData data) {
        this.entityId = entityId;
        this.data = data;
    }

    public SyncStaffAbilityDataPayload(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.data = (StaffAbilityData)StaffAbilityData.STREAM_CODEC.decode((Object)buf);
    }

    public void handle(IPayloadContext context) {
        Entity entity = context.player().level().getEntity(this.entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.setData(MalumAttachmentTypes.STAFF_ABILITIES.get(), (Object)this.data);
        }
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        StaffAbilityData.STREAM_CODEC.encode((Object)buf, (Object)this.data);
    }
}

