/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.base.spirit;

import com.sammy.malum.common.packets.particle.base.PositionBasedParticleEffectPacket;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class SpiritBasedParticleEffectPacket
extends PositionBasedParticleEffectPacket {
    protected final List<String> spirits;

    public SpiritBasedParticleEffectPacket(List<String> spirits, Vec3 pos) {
        super(pos.x, pos.y, pos.z);
        this.spirits = spirits;
    }

    public SpiritBasedParticleEffectPacket(FriendlyByteBuf buf) {
        super(buf);
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.readUtf());
        }
        this.spirits = spirits;
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.writeUtf(string);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(IPayloadContext iPayloadContext) {
    }

    protected abstract void handle(IPayloadContext var1, MalumSpiritType var2);

    public static <T extends SpiritBasedParticleEffectPacket> T decode(PacketProvider<T> provider, FriendlyByteBuf buf) {
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.readUtf());
        }
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        return provider.getPacket(spirits, posX, posY, posZ);
    }

    public static interface PacketProvider<T extends SpiritBasedParticleEffectPacket> {
        public T getPacket(List<String> var1, double var2, double var4, double var6);
    }
}

