/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.registry.common.recipe.MalumRecipeSerializers;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.List;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.systems.recipe.LodestoneInWorldRecipe;

public class SoulBindingRecipe
extends LodestoneInWorldRecipe<SpiritBasedRecipeInput> {
    public static final MapCodec<SoulBindingRecipe> CODEC = RecordCodecBuilder.mapCodec(obj -> obj.group((App)SizedIngredient.FLAT_CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)GeasEffectType.CODEC.fieldOf("geas").forGetter(recipe -> recipe.geas), (App)SizedIngredient.FLAT_CODEC.listOf().optionalFieldOf("extraIngredients", List.of()).forGetter(recipe -> recipe.extraIngredients), (App)SpiritIngredient.CODEC.codec().listOf().fieldOf("spirits").forGetter(recipe -> recipe.spirits), (App)Codec.BOOL.optionalFieldOf("carryOverComponentData", (Object)false).forGetter(recipe -> recipe.carryOverData)).apply((Applicative)obj, SoulBindingRecipe::new));
    public static final String NAME = "soul_binding";
    public final SizedIngredient ingredient;
    public final GeasEffectType geas;
    public final List<SizedIngredient> extraIngredients;
    public final List<SpiritIngredient> spirits;
    public final boolean carryOverData;

    public SoulBindingRecipe(SizedIngredient ingredient, GeasEffectType geas, List<SizedIngredient> extraIngredients, List<SpiritIngredient> spirits, boolean carryOverData) {
        super((RecipeSerializer)MalumRecipeSerializers.SOUL_BINDING_RECIPE_SERIALIZER.get(), (RecipeType)MalumRecipeTypes.SOUL_BINDING.get());
        this.ingredient = ingredient;
        this.geas = geas;
        this.extraIngredients = extraIngredients;
        this.spirits = spirits;
        this.carryOverData = carryOverData;
    }

    public boolean matches(SpiritBasedRecipeInput input, Level level) {
        return input.test(this.ingredient, this.extraIngredients, this.spirits);
    }
}

