/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.registry.common.recipe.MalumRecipeSerializers;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.systems.recipe.LodestoneInWorldRecipe;

public class SpiritFocusingRecipe
extends LodestoneInWorldRecipe<SpiritBasedRecipeInput> {
    public static final MapCodec<SpiritFocusingRecipe> CODEC = RecordCodecBuilder.mapCodec(obj -> obj.group((App)Codec.INT.fieldOf("time").forGetter(recipe -> recipe.time), (App)Codec.INT.fieldOf("durabilityCost").forGetter(recipe -> recipe.durabilityCost), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)SpiritIngredient.CODEC.codec().listOf().fieldOf("spirits").forGetter(recipe -> recipe.spirits)).apply((Applicative)obj, SpiritFocusingRecipe::new));
    public static final String NAME = "spirit_focusing";
    public final int time;
    public final int durabilityCost;
    public final Ingredient ingredient;
    public final ItemStack output;
    public final List<SpiritIngredient> spirits;

    public SpiritFocusingRecipe(int time, int durabilityCost, Ingredient ingredient, ItemStack output, List<SpiritIngredient> spirits) {
        super((RecipeSerializer)MalumRecipeSerializers.FOCUSING_RECIPE_SERIALIZER.get(), (RecipeType)MalumRecipeTypes.SPIRIT_FOCUSING.get());
        this.time = time;
        this.durabilityCost = durabilityCost;
        this.ingredient = ingredient;
        this.output = output;
        this.spirits = spirits;
    }

    public boolean matches(SpiritBasedRecipeInput input, Level level) {
        return input.test(new SizedIngredient(this.ingredient, 1), this.spirits);
    }
}

