/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe.node_cooking;

import com.sammy.malum.common.recipe.node_cooking.INodeCookingRecipe;
import com.sammy.malum.common.recipe.node_cooking.NodeCookingSerializer;
import com.sammy.malum.registry.common.recipe.MalumRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;

public class MetalNodeBlastingRecipe
extends BlastingRecipe
implements INodeCookingRecipe {
    public static final String NAME = "node_blasting";
    private final Ingredient rawOutput;
    private final int outputCount;
    private ItemStack outputCache;

    public MetalNodeBlastingRecipe(String group, Ingredient ingredient, Ingredient output, int outputCount, float experience, int cookingTime) {
        super(group, CookingBookCategory.MISC, ingredient, ItemStack.EMPTY, experience, cookingTime);
        this.rawOutput = output;
        this.outputCount = outputCount;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MalumRecipeSerializers.METAL_NODE_BLASTING_SERIALIZER.get();
    }

    @Override
    public Ingredient getInput() {
        return this.ingredient;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    @Override
    public Ingredient getRawOutput() {
        return this.rawOutput;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.getOutput();
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return this.getResultItem(registries).copy();
    }

    @Override
    public ItemStack getOutput() {
        if (this.outputCache == null) {
            this.outputCache = NodeCookingSerializer.getStackFromIngredient(this.rawOutput).copyWithCount(this.outputCount);
        }
        return this.outputCache;
    }
}

