/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class SacredRiteType
extends TotemicRiteType {
    public static final Map<Class<? extends Mob>, NourishmentRiteActor<?>> NOURISHMENT_RITE_ACTORS = (Map)Util.make(new HashMap(), m -> {
        m.put(Sheep.class, new NourishmentRiteActor<Sheep>(Sheep.class){

            @Override
            public boolean act(TotemBaseBlockEntity totemBaseBlockEntity, Sheep sheep) {
                if (sheep.getRandom().nextFloat() < 0.6f) {
                    BlockPos blockpos = sheep.blockPosition();
                    Level level = sheep.level();
                    if (EatBlockGoal.IS_TALL_GRASS.test(level.getBlockState(blockpos)) || level.getBlockState(blockpos.below()).is(Blocks.GRASS_BLOCK)) {
                        EatBlockGoal goal = sheep.eatBlockGoal;
                        goal.start();
                        return true;
                    }
                }
                return false;
            }
        });
        m.put(Bee.class, new NourishmentRiteActor<Bee>(Bee.class){

            @Override
            public boolean act(TotemBaseBlockEntity totemBaseBlockEntity, Bee bee) {
                Bee.BeePollinateGoal goal = bee.beePollinateGoal;
                if (goal.canBeeUse()) {
                    goal.successfulPollinatingTicks += 40;
                    goal.tick();
                    return true;
                }
                return false;
            }
        });
        m.put(Chicken.class, new NourishmentRiteActor<Chicken>(Chicken.class){

            @Override
            public boolean act(TotemBaseBlockEntity totemBaseBlockEntity, Chicken chicken) {
                chicken.eggTime -= 80;
                return true;
            }
        });
        m.put(Allay.class, new NourishmentRiteActor<Allay>(Allay.class){

            @Override
            public boolean act(TotemBaseBlockEntity totemBaseBlockEntity, Allay allay) {
                allay.duplicationCooldown -= 80L;
                return true;
            }
        });
    });

    public SacredRiteType() {
        super("sacred_rite", MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, LivingEntity.class, e -> !(e instanceof Monster)).forEach(e -> {
                    if (e.getHealth() < e.getMaxHealth()) {
                        e.heal(2.0f);
                        MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)e).color(MalumSpiritTypes.SACRED_SPIRIT).spawn(level);
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, Mob.class).forEach(e -> {
                    Animal animal;
                    if (e instanceof Animal && (animal = (Animal)e).getAge() < 0 && totemBase.getLevel().random.nextFloat() <= 0.04f) {
                        MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)e).color(MalumSpiritTypes.SACRED_SPIRIT).spawn(level);
                        animal.ageUp(25);
                    }
                    if (NOURISHMENT_RITE_ACTORS.containsKey(e.getClass())) {
                        NourishmentRiteActor<?> nourishmentRiteActor = NOURISHMENT_RITE_ACTORS.get(e.getClass());
                        nourishmentRiteActor.tryAct(level, totemBase, (Mob)e);
                    }
                });
            }
        };
    }

    public static abstract class NourishmentRiteActor<T extends Mob> {
        public final Class<T> targetClass;

        public NourishmentRiteActor(Class<T> targetClass) {
            this.targetClass = targetClass;
        }

        public final void tryAct(ServerLevel level, TotemBaseBlockEntity totemBaseBlockEntity, Mob mob) {
            if (this.targetClass.isInstance(mob)) {
                this.act(totemBaseBlockEntity, mob);
                MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)mob).color(MalumSpiritTypes.SACRED_SPIRIT).spawn(level);
            }
        }

        public abstract boolean act(TotemBaseBlockEntity var1, T var2);
    }
}

