/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldevent;

import com.sammy.malum.common.block.blight.CreepingBlightBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.common.worldevent.ActiveBlightWorldEvent;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumWorldEventTypes;
import com.sammy.malum.registry.common.block.MalumBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class UnchainedTotemConversionWorldEvent
extends ActiveBlightWorldEvent {
    public int transformedTotemParts;

    public UnchainedTotemConversionWorldEvent() {
        super((WorldEventType)MalumWorldEventTypes.UNCHAINED_TOTEM_CONVERSION.get());
    }

    @Override
    public void createBlight(ServerLevel level, int intensity) {
        super.createBlight(level, intensity);
        if (this.transformedTotemParts == 0) {
            BlockState state = BlockStateHelper.setBlockStateWithExistingProperties((Level)level, (BlockPos)this.position, (BlockState)((Block)MalumBlocks.SOULWOOD_TOTEM_BASE.get()).defaultBlockState(), (int)3);
            this.placeBlock(level, this.position, state);
            ++this.transformedTotemParts;
            return;
        }
        int offset = this.transformedTotemParts;
        BlockPos totemPos = this.position.above(offset);
        BlockEntity blockEntity = level.getBlockEntity(totemPos);
        if (blockEntity instanceof TotemPoleBlockEntity) {
            TotemPoleBlockEntity totemPoleTile = (TotemPoleBlockEntity)blockEntity;
            this.placeTotemPole(level, totemPos, totemPoleTile.spirit);
        }
        ++this.transformedTotemParts;
    }

    public void placeTotemPole(ServerLevel level, BlockPos pos, MalumSpiritType spiritType) {
        BlockState totemPoleState = BlockStateHelper.setBlockStateWithExistingProperties((Level)level, (BlockPos)pos, (BlockState)((Block)MalumBlocks.SOULWOOD_TOTEM_POLE.get()).defaultBlockState(), (int)3);
        TotemPoleBlockEntity totemPole = new TotemPoleBlockEntity(pos, totemPoleState);
        totemPole.setLevel((Level)level);
        totemPole.setSpirit(level, spiritType);
        level.setBlockEntity((BlockEntity)totemPole);
        this.placeBlock(level, pos, totemPoleState);
        this.maybePlaceBlightedGunk(level, pos, totemPoleState);
    }

    public void placeBlock(ServerLevel level, BlockPos pos, BlockState state) {
        level.setBlockAndUpdate(pos, state);
        level.levelEvent(null, 2001, pos, Block.getId((BlockState)state));
        level.playSound(null, pos, (SoundEvent)MalumSoundEvents.MINOR_BLIGHT_MOTIF.get(), SoundSource.BLOCKS, 1.0f, RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)1.6f, (float)2.0f));
    }

    public void maybePlaceBlightedGunk(ServerLevel level, BlockPos pos, BlockState totemPoleState) {
        RandomSource random = level.getRandom();
        if (random.nextFloat() < 0.4f) {
            Direction direction = Direction.from2DDataValue((int)random.nextInt(4));
            if (direction.equals((Object)totemPoleState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))) {
                return;
            }
            BlockState state = (BlockState)((BlockState)((Block)MalumBlocks.CLINGING_BLIGHT.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction.getOpposite())).setValue(CreepingBlightBlock.BLIGHT_TYPE, (Comparable)((Object)CreepingBlightBlock.BlightType.SOULWOOD_SPIKE));
            this.placeBlock(level, pos.relative(direction), state);
        }
    }
}

