/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.blight;

import com.sammy.malum.common.block.blight.scarstone.LargeStrangeCrystalBlock;
import com.sammy.malum.common.worldgen.blight.BlightFeature;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.block.MalumBlocks;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ScarstoneFeature
extends Feature<NoneFeatureConfiguration> {
    public ScarstoneFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        ScarstoneFeature.generateScarstone(level, pos, 6).place(level);
        return true;
    }

    public static BlightFeature.LodestoneWorldgenBuilder generateScarstone(WorldGenLevel level, BlockPos pos, int radius) {
        RandomSource random = level.getRandom();
        BlightFeature.LodestoneWorldgenBuilder builder = BlightFeature.LodestoneWorldgenBuilder.create().addAdditionalPlacement(BlightFeature::cleanupFoliage);
        BlightFeature.LodestoneWorldgenBuilderLayer scarstoneLayer = builder.createLayer();
        BlightFeature.LodestoneWorldgenBuilderLayer floraLayer = builder.createLayer();
        List<BlockPos> scarredArea = ScarstoneFeature.fetchCoveringPositions((ServerLevelAccessor)level, pos, radius);
        for (BlockPos blockPos : scarredArea) {
            BlockState state = level.getBlockState(blockPos);
            if (!state.is(MalumTags.BlockTags.BLIGHT_REPLACEABLE) && !state.is(MalumTags.BlockTags.BLIGHT)) continue;
            scarstoneLayer.add(blockPos, (Block)MalumBlocks.SCARSTONE.get()).setImportant();
        }
        List<BlockPos> crystalPositions = ScarstoneFeature.fetchCoveringPositions((ServerLevelAccessor)level, pos, radius - 1);
        if (!crystalPositions.isEmpty()) {
            Collections.shuffle(crystalPositions);
            int floraCount = Math.min(random.nextInt(radius * 2 + 1, radius * 4 + 1), crystalPositions.size() - 1);
            for (BlockPos blockPos : crystalPositions) {
                BlockPos above = blockPos.above();
                BlockState state = level.getBlockState(above);
                if (!state.getFluidState().isEmpty() || !state.canBeReplaced()) continue;
                Block block = random.nextFloat() < 0.7f ? (random.nextFloat() < 0.4f ? (Block)MalumBlocks.LARGE_STRANGE_CRYSTAL.get() : (Block)MalumBlocks.STRANGE_CRYSTAL.get()) : (Block)MalumBlocks.STRANGEROOT.get();
                BlightFeature.LodestoneWorldgenBuilderEntry entry = floraLayer.add(above, block).setImportant();
                if (block.equals(MalumBlocks.LARGE_STRANGE_CRYSTAL.get())) {
                    entry.addAdditionalPlacement((l, e) -> e.place(l, e.position().above(), (BlockState)e.state.setValue(LargeStrangeCrystalBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)));
                }
                if (--floraCount != 0) continue;
                break;
            }
        }
        return builder;
    }

    public static List<BlockPos> fetchCoveringPositions(ServerLevelAccessor level, BlockPos center, int radius) {
        return BlightFeature.fetchCoveringPositions(level, center, radius, ScarstoneFeature::canBeRemoved).stream().filter(p -> {
            BlockState above = level.getBlockState(p.above());
            return above.canBeReplaced() || above.is(MalumTags.BlockTags.BLIGHT_REMOVABLE) || above.is(MalumTags.BlockTags.BLIGHTED_PLANTS);
        }).collect(Collectors.toList());
    }

    public static boolean canBeRemoved(BlockState state) {
        return state.canBeReplaced();
    }
}

