/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.ore;

import com.mojang.serialization.Codec;
import com.sammy.malum.common.worldgen.ore.LayeredOreFeature;
import com.sammy.malum.registry.common.block.MalumBlocks;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class CthonicGoldOreFeature
extends LayeredOreFeature {
    public CthonicGoldOreFeature() {
        super((Codec<OreConfiguration>)OreConfiguration.CODEC);
    }

    protected boolean doPlace(WorldGenLevel pLevel, RandomSource pRandom, OreConfiguration pConfig, double pMinX, double pMaxX, double pMinZ, double pMaxZ, double pMinY, double pMaxY, int pX, int pY, int pZ, int pWidth, int pHeight) {
        int i = 0;
        boolean isCthonicGold = ((OreConfiguration.TargetBlockState)pConfig.targetStates.get((int)0)).state.getBlock().equals(MalumBlocks.CTHONIC_GOLD_ORE.get());
        ArrayList<Runnable> clusterPlacements = new ArrayList<Runnable>();
        ArrayList<Runnable> cthonicGoldPlacements = isCthonicGold ? new ArrayList<Runnable>() : null;
        BitSet bitset = new BitSet(pWidth * pHeight * pWidth);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int j = pConfig.size;
        double[] adouble = new double[j * 4];
        for (int k = 0; k < j; ++k) {
            float f = (float)k / (float)j;
            double d0 = Mth.lerp((double)f, (double)pMinX, (double)pMaxX);
            double d1 = Mth.lerp((double)f, (double)pMinY, (double)pMaxY);
            double d2 = Mth.lerp((double)f, (double)pMinZ, (double)pMaxZ);
            double d3 = pRandom.nextDouble() * (double)j / 16.0;
            double d4 = ((double)(Mth.sin((float)((float)Math.PI * f)) + 1.0f) * d3 + 1.0) / 2.0;
            adouble[k * 4] = d0;
            adouble[k * 4 + 1] = d1;
            adouble[k * 4 + 2] = d2;
            adouble[k * 4 + 3] = d4;
        }
        for (int l3 = 0; l3 < j - 1; ++l3) {
            if (adouble[l3 * 4 + 3] <= 0.0) continue;
            for (int i4 = l3 + 1; i4 < j; ++i4) {
                double d12;
                double d10;
                double d8;
                double d14;
                if (adouble[i4 * 4 + 3] <= 0.0 || !((d14 = adouble[l3 * 4 + 3] - adouble[i4 * 4 + 3]) * d14 > (d8 = adouble[l3 * 4] - adouble[i4 * 4]) * d8 + (d10 = adouble[l3 * 4 + 1] - adouble[i4 * 4 + 1]) * d10 + (d12 = adouble[l3 * 4 + 2] - adouble[i4 * 4 + 2]) * d12)) continue;
                if (d14 > 0.0) {
                    adouble[i4 * 4 + 3] = -1.0;
                    continue;
                }
                adouble[l3 * 4 + 3] = -1.0;
            }
        }
        try (BulkSectionAccess bulksectionaccess = new BulkSectionAccess((LevelAccessor)pLevel);){
            for (int j4 = 0; j4 < j; ++j4) {
                double d9 = adouble[j4 * 4 + 3];
                if (d9 < 0.0) continue;
                double d11 = adouble[j4 * 4];
                double d13 = adouble[j4 * 4 + 1];
                double d15 = adouble[j4 * 4 + 2];
                int k4 = Math.max(Mth.floor((double)(d11 - d9)), pX);
                int l = Math.max(Mth.floor((double)(d13 - d9)), pY);
                int i1 = Math.max(Mth.floor((double)(d15 - d9)), pZ);
                int j1 = Math.max(Mth.floor((double)(d11 + d9)), k4);
                int k1 = Math.max(Mth.floor((double)(d13 + d9)), l);
                int l1 = Math.max(Mth.floor((double)(d15 + d9)), i1);
                for (int i2 = k4; i2 <= j1; ++i2) {
                    double d5 = ((double)i2 + 0.5 - d11) / d9;
                    if (!(d5 * d5 < 1.0)) continue;
                    for (int j2 = l; j2 <= k1; ++j2) {
                        double d6 = ((double)j2 + 0.5 - d13) / d9;
                        if (!(d5 * d5 + d6 * d6 < 1.0)) continue;
                        block12: for (int k2 = i1; k2 <= l1; ++k2) {
                            LevelChunkSection section;
                            int l2;
                            double d7 = ((double)k2 + 0.5 - d15) / d9;
                            if (!(d5 * d5 + d6 * d6 + d7 * d7 < 1.0) || pLevel.isOutsideBuildHeight(j2) || bitset.get(l2 = i2 - pX + (j2 - pY) * pWidth + (k2 - pZ) * pWidth * pHeight)) continue;
                            bitset.set(l2);
                            mutable.set(i2, j2, k2);
                            if (!pLevel.ensureCanWrite((BlockPos)mutable) || (section = bulksectionaccess.getSection((BlockPos)mutable)) == null) continue;
                            int x = SectionPos.sectionRelative((int)i2);
                            int y = SectionPos.sectionRelative((int)j2);
                            int z = SectionPos.sectionRelative((int)k2);
                            BlockState blockstate = section.getBlockState(x, y, z);
                            for (OreConfiguration.TargetBlockState oreconfiguration$targetblockstate : pConfig.targetStates) {
                                if (!CthonicGoldOreFeature.canPlaceOre((BlockState)blockstate, arg_0 -> ((BulkSectionAccess)bulksectionaccess).getBlockState(arg_0), (RandomSource)pRandom, (OreConfiguration)pConfig, (OreConfiguration.TargetBlockState)oreconfiguration$targetblockstate, (BlockPos.MutableBlockPos)mutable)) continue;
                                if (isCthonicGold) {
                                    cthonicGoldPlacements.add(() -> section.setBlockState(x, y, z, oreconfiguration$targetblockstate.state, false));
                                } else {
                                    section.setBlockState(x, y, z, oreconfiguration$targetblockstate.state, false);
                                }
                                for (Direction direction : Direction.values()) {
                                    int clusterZ;
                                    int clusterY;
                                    int clusterX;
                                    LevelChunkSection offsetSection;
                                    mutable.set(i2, j2, k2).move(direction);
                                    if (!pLevel.ensureCanWrite((BlockPos)mutable) || (offsetSection = bulksectionaccess.getSection((BlockPos)mutable)) == null || !offsetSection.getBlockState(clusterX = SectionPos.sectionRelative((int)mutable.getX()), clusterY = SectionPos.sectionRelative((int)mutable.getY()), clusterZ = SectionPos.sectionRelative((int)mutable.getZ())).isAir()) continue;
                                    clusterPlacements.add(() -> offsetSection.setBlockState(clusterX, clusterY, clusterZ, (BlockState)((Block)MalumBlocks.CTHONIC_GOLD_CLUSTER.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)direction), false));
                                }
                                if (!isCthonicGold || ++i < 3) continue block12;
                                cthonicGoldPlacements.forEach(Runnable::run);
                                this.placeClusters(clusterPlacements, pRandom);
                                boolean bl = true;
                                return bl;
                            }
                        }
                    }
                }
            }
            if (isCthonicGold ? i >= 3 : i > 0) {
                this.placeClusters(clusterPlacements, pRandom);
            }
        }
        return isCthonicGold ? i >= 3 : i > 0;
    }

    public void placeClusters(List<Runnable> clusterPlacements, RandomSource random) {
        if (!clusterPlacements.isEmpty()) {
            Collections.shuffle(clusterPlacements);
            int clusterAmount = (clusterPlacements.size() + random.nextInt(4)) / 3;
            if (clusterAmount != 0) {
                for (int k = 0; k < Math.min(clusterAmount, clusterPlacements.size()); ++k) {
                    clusterPlacements.get(k).run();
                }
            }
        }
    }
}

