/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.irons_spellbooks;

import com.google.common.collect.Multimap;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.soul_data.LivingSoulData;
import com.sammy.malum.common.effect.EchoingArcanaEffect;
import com.sammy.malum.common.effect.SilencedEffect;
import com.sammy.malum.common.effect.gluttony.DesperateNeedEffect;
import com.sammy.malum.common.effect.gluttony.GluttonyEffect;
import com.sammy.malum.common.effect.gluttony.TrialOfFaithEffect;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.enchantment.EnchantmentKeys;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerCooldowns;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class IronsSpellsCompat {
    public static boolean LOADED;

    public static void init() {
        LOADED = ModList.get().isLoaded("irons_spellbooks");
        if (LOADED) {
            NeoForge.EVENT_BUS.addListener(LoadedOnly::spellDamage);
            NeoForge.EVENT_BUS.addListener(LoadedOnly::triggerReplenishing);
        }
    }

    public static void generateMana(ServerPlayer collector, double amount) {
        IronsSpellsCompat.generateMana(collector, (float)amount);
    }

    public static void generateMana(ServerPlayer collector, float amount) {
        if (LOADED) {
            LoadedOnly.generateMana(collector, amount);
        }
    }

    public static void recoverSpellCooldowns(LivingEntity mage, int enchantmentLevel) {
        if (LOADED) {
            LoadedOnly.recoverSpellCooldowns(mage, enchantmentLevel);
        }
    }

    public static void addSoulHunterSpellPower(ItemAttributeModifiers.Builder attributes, EquipmentSlotGroup group) {
        if (LOADED) {
            LoadedOnly.addSoulHunterSpellPower(attributes, group);
        }
    }

    public static void addSpellPowerToCurio(MalumCurioItem item, Multimap<Holder<Attribute>, AttributeModifier> map, ResourceLocation id, float amount) {
        if (LOADED) {
            LoadedOnly.addSpellPowerToCurio(item, map, id, amount);
        }
    }

    public static void addEchoingArcanaSpellCooldown(EchoingArcanaEffect effect) {
        if (LOADED) {
            LoadedOnly.addEchoingArcanaSpellCooldown(effect);
        }
    }

    public static void addGluttonySpellPower(GluttonyEffect effect) {
        if (LOADED) {
            LoadedOnly.addGluttonySpellPower(effect);
        }
    }

    public static void addTrialOfFaithSpellPower(TrialOfFaithEffect effect) {
        if (LOADED) {
            LoadedOnly.addTrialOfFaithSpellPower(effect);
        }
    }

    public static void addDesperateNeedSpellPower(DesperateNeedEffect effect) {
        if (LOADED) {
            LoadedOnly.addDesperateNeedSpellPower(effect);
        }
    }

    public static void addSilencedNegativeAttributeModifiers(SilencedEffect effect) {
        if (LOADED) {
            LoadedOnly.addSilencedNegativeAttributeModifiers(effect);
        }
    }

    public static class LoadedOnly {
        public static void spellDamage(SpellDamageEvent event) {
            boolean canShatter = event.getEntity() instanceof Player ? (Boolean)CommonConfig.IRONS_SPELLBOOKS_SPIRIT_DAMAGE.getConfigValue() : (Boolean)CommonConfig.IRONS_SPELLBOOKS_NON_PLAYER_SPIRIT_DAMAGE.getConfigValue();
            if (canShatter) {
                ((LivingSoulData)event.getEntity().getData(MalumAttachmentTypes.LIVING_SOUL_INFO)).setExposed();
            }
        }

        public static void triggerReplenishing(LivingDamageEvent.Post event) {
            ServerPlayer serverPlayer;
            DamageSource source = event.getSource();
            Entity directEntity = source.getDirectEntity();
            if (directEntity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)directEntity).getAttackStrengthScale(0.0f) > 0.8f) {
                ItemStack stack = serverPlayer.getMainHandItem();
                int level = EnchantmentKeys.getEnchantmentLevel(serverPlayer.level(), EnchantmentKeys.REPLENISHING, stack);
                LoadedOnly.recoverSpellCooldowns((LivingEntity)serverPlayer, 0.025f * (float)level);
            }
        }

        public static void generateMana(ServerPlayer mage, float amount) {
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)mage);
            magicData.addMana(amount);
        }

        public static void recoverSpellCooldowns(LivingEntity mage, float amount) {
            PlayerCooldowns cooldowns = MagicData.getPlayerMagicData((LivingEntity)mage).getPlayerCooldowns();
            cooldowns.getSpellCooldowns().forEach((key, value) -> cooldowns.decrementCooldown(value, (int)((float)value.getSpellCooldown() * amount)));
            if (mage instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)mage;
                cooldowns.syncToPlayer(serverPlayer);
            }
        }

        public static void addSoulHunterSpellPower(ItemAttributeModifiers.Builder attributes, EquipmentSlotGroup group) {
            attributes.add((Holder)AttributeRegistry.SPELL_POWER, new AttributeModifier(MalumMod.malumPath("soul_hunter_armor"), (double)0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), group);
        }

        public static void addSpellPowerToCurio(MalumCurioItem item, Multimap<Holder<Attribute>, AttributeModifier> map, ResourceLocation id, float amount) {
            item.addAttributeModifier(map, (Holder<Attribute>)AttributeRegistry.SPELL_POWER, new AttributeModifier(id, (double)amount, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }

        public static void addEchoingArcanaSpellCooldown(EchoingArcanaEffect effect) {
            effect.addAttributeModifier((Holder)AttributeRegistry.COOLDOWN_REDUCTION, MalumMod.malumPath("echoing_arcana"), 0.02f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        }

        public static void addGluttonySpellPower(GluttonyEffect effect) {
            effect.addAttributeModifier((Holder)AttributeRegistry.SPELL_POWER, MalumMod.malumPath("gluttony"), 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }

        public static void addTrialOfFaithSpellPower(TrialOfFaithEffect effect) {
            effect.addAttributeModifier((Holder)AttributeRegistry.HOLY_SPELL_POWER, MalumMod.malumPath("trial_of_faith"), 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            effect.addAttributeModifier((Holder)AttributeRegistry.BLOOD_SPELL_POWER, MalumMod.malumPath("trial_of_faith"), 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }

        public static void addDesperateNeedSpellPower(DesperateNeedEffect effect) {
            effect.addAttributeModifier((Holder)AttributeRegistry.NATURE_SPELL_POWER, MalumMod.malumPath("trial_of_faith"), 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            effect.addAttributeModifier((Holder)AttributeRegistry.BLOOD_SPELL_POWER, MalumMod.malumPath("trial_of_faith"), 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }

        public static void addSilencedNegativeAttributeModifiers(SilencedEffect effect) {
            effect.addAttributeModifier((Holder)AttributeRegistry.MANA_REGEN, MalumMod.malumPath("silenced"), -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            effect.addAttributeModifier((Holder)AttributeRegistry.SPELL_POWER, MalumMod.malumPath("silenced"), -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
    }
}

