/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.common.data.attachment.CachedSpiritDropsData;
import com.sammy.malum.core.handlers.SoulHarvestHandler;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public class EnsouledItemHarvestHandler {
    public static void onDrops(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        EntitySpiritDropData.getSpiritData(entity).map(EntitySpiritDropData::getItemAsSoul).ifPresent(itemAsSoul -> {
            for (ItemEntity item : event.getDrops()) {
                if (!itemAsSoul.test(item.getItem())) continue;
                EnsouledItemHarvestHandler.moveSpiritDropsOntoItem(item, entity);
            }
        });
    }

    public static void moveSpiritDropsOntoItem(ItemEntity item, LivingEntity entity) {
        CachedSpiritDropsData entityData = (CachedSpiritDropsData)entity.getData(MalumAttachmentTypes.CACHED_SPIRIT_DROPS);
        item.setData(MalumAttachmentTypes.CACHED_SPIRIT_DROPS, (Object)entityData);
        item.setNeverPickUp();
        item.age = item.lifespan - 20;
        item.setNoGravity(true);
        item.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.5, 1.0));
    }

    public static void onItemExpire(ItemExpireEvent event) {
        ItemEntity item = event.getEntity();
        Level level = item.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            CachedSpiritDropsData data = (CachedSpiritDropsData)item.getData(MalumAttachmentTypes.CACHED_SPIRIT_DROPS);
            if (!data.getSpiritDrops().isEmpty()) {
                SoulHarvestHandler.spawnSpirits((Entity)item).setPreferredCollector(data.getSpiritOwner().map(arg_0 -> ((ServerLevel)level2).getEntity(arg_0)).map(e -> {
                    LivingEntity entity;
                    return e instanceof LivingEntity ? (entity = (LivingEntity)e) : null;
                }).orElse(null)).setCustomItems(data.getSpiritDrops()).spawnSpirits((Level)level2);
            }
        }
    }
}

