/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.soul_data.GeasSoulData;
import com.sammy.malum.common.data.component.GeasDataComponent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.handlers.ItemEventHandler;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.extensions.ICurioSlotExtension;
import top.theillusivec4.curios.api.extensions.RegisterCuriosExtensionsEvent;

public class GeasEffectHandler {
    public static final ItemEventHandler.EventResponderSource GEAS_EFFECTS = ItemEventHandler.registerLookup((ItemEventHandler.EventResponderSource)new ItemEventHandler.EventResponderSource(MalumMod.malumPath("geas_effects"), GeasEffectHandler::getGeasItemStacks, GeasEffectHandler::getEquippedGeasEffectFromStack));

    public static void registerSlotExtensions(RegisterCuriosExtensionsEvent event) {
        event.registerSlotExtension(new ICurioSlotExtension(){

            public ItemStack getDisplayStack(SlotContext slotContext, ItemStack defaultStack) {
                List<ItemStack> geasItemStacks = GeasEffectHandler.getGeasItemStacks(slotContext.entity());
                if (geasItemStacks == null) {
                    return ItemStack.EMPTY;
                }
                if (geasItemStacks.size() > slotContext.index()) {
                    return geasItemStacks.get(slotContext.index());
                }
                return ItemStack.EMPTY;
            }
        }, new String[]{"geas"});
    }

    public static void syncGeas(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Level level = living.level();
            if (!level.isClientSide) {
                GeasSoulData data = (GeasSoulData)living.getData(MalumAttachmentTypes.GEAS_SOUL_INFO);
                data.setDirty(true);
            }
        }
    }

    public static void entityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            GeasEffectHandler.getGeasEffects(living).forEach(e -> {
                e.updateAttributes(living);
                e.update(event, living);
            });
        }
    }

    public static boolean addGeasEffect(LivingEntity entity, GeasEffectType geas) {
        return GeasEffectHandler.getGeasData(entity).tryAddGeasEffect(entity, geas);
    }

    public static boolean hasGeasEffect(LivingEntity entity, Holder<GeasEffectType> type) {
        return GeasEffectHandler.getGeasData(entity).hasGeasEffect(entity, type);
    }

    public static boolean hasGeasEffect(LivingEntity entity, GeasEffectType type) {
        return GeasEffectHandler.getGeasData(entity).hasGeasEffect(entity, type);
    }

    public static boolean removeGeasEffect(LivingEntity entity, GeasEffectType geas) {
        return GeasEffectHandler.getGeasData(entity).removeGeasEffect(geas);
    }

    public static List<ItemStack> getGeasItemStacks(LivingEntity entity) {
        return GeasEffectHandler.getGeasData(entity).getGeasItemStacks(entity);
    }

    public static GeasEffect getGeasEffect(LivingEntity entity, Holder<GeasEffectType> type) {
        return GeasEffectHandler.getGeasData(entity).getGeasEffect(entity, type);
    }

    public static List<GeasEffect> getGeasEffects(LivingEntity entity) {
        return GeasEffectHandler.getGeasData(entity).getGeasEffects(entity);
    }

    public static GeasEffect getEquippedGeasEffectFromStack(LivingEntity entity, ItemStack stack) {
        GeasDataComponent component = GeasEffectHandler.getStoredGeasEffect(stack).orElse(null);
        if (component == null) {
            return null;
        }
        GeasEffectType geas = component.geasEffectType();
        return GeasEffectHandler.getGeasData(entity).getGeasEffect(entity, geas);
    }

    public static GeasSoulData getGeasData(LivingEntity entity) {
        return (GeasSoulData)entity.getData(MalumAttachmentTypes.GEAS_SOUL_INFO);
    }

    public static Optional<GeasDataComponent> getStoredGeasEffect(ItemStack stack) {
        if (!stack.has(MalumDataComponents.GEAS_EFFECT)) {
            return Optional.empty();
        }
        GeasDataComponent component = (GeasDataComponent)stack.get(MalumDataComponents.GEAS_EFFECT);
        if (component.isInvalid()) {
            return Optional.empty();
        }
        return Optional.of(component);
    }
}

