/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.common.data.attachment.SoulWardData;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.systems.events.ModifySoulWardPropertiesEvent;
import com.sammy.malum.core.systems.events.SoulWardDamageEvent;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.handlers.ItemEventHandler;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;

public class SoulWardHandler {
    public static void syncSoulWard(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Level level = living.level();
            if (!level.isClientSide) {
                SoulWardData data = (SoulWardData)living.getData(MalumAttachmentTypes.SOUL_WARD);
                data.setDirty(true);
            }
        }
    }

    public static void entityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Level level = living.level();
            if (!level.isClientSide) {
                SoulWardData data = (SoulWardData)living.getData(MalumAttachmentTypes.SOUL_WARD);
                data.tickData(living);
            }
        }
    }

    public static void shieldPlayer(LivingDamageEvent.Pre event) {
        LivingEntity living = event.getEntity();
        if (living.level().isClientSide()) {
            return;
        }
        if (event.getNewDamage() <= 0.0f) {
            return;
        }
        SoulWardData data = (SoulWardData)living.getData(MalumAttachmentTypes.SOUL_WARD);
        data.addCooldown(living, 4.0);
        if (!data.isDepleted()) {
            DamageSource source = event.getSource();
            float amount = event.getNewDamage();
            double magicDamageAbsorption = 1.0 - (Double)CommonConfig.SOUL_WARD_MAGIC.getConfigValue();
            double physicalDamageAbsorption = 1.0 - (Double)CommonConfig.SOUL_WARD_PHYSICAL.getConfigValue();
            double integrity = living.getAttributeValue(MalumAttributes.SOUL_WARD_INTEGRITY) * 2.0;
            List eventResponders = ItemEventHandler.getEventResponders((LivingEntity)living);
            ModifySoulWardPropertiesEvent propertiesEvent = new ModifySoulWardPropertiesEvent(living, data, source, physicalDamageAbsorption, magicDamageAbsorption, integrity);
            eventResponders.forEach(lookup -> lookup.run(IMalumEventResponder.class, (eventResponderItem, stack) -> eventResponderItem.modifySoulWardPropertiesEvent(propertiesEvent, living, (ItemStack)stack)));
            NeoForge.EVENT_BUS.post((Event)propertiesEvent);
            magicDamageAbsorption = propertiesEvent.getNewMagicDamageAbsorption();
            physicalDamageAbsorption = propertiesEvent.getNewPhysicalDamageAbsorption();
            integrity = propertiesEvent.getNewIntegrity();
            double absorptionMultiplier = source.is(LodestoneDamageTypeTags.IS_MAGIC) ? magicDamageAbsorption : physicalDamageAbsorption;
            double absorbedDamage = (double)amount * absorptionMultiplier;
            double soulWardDamage = absorbedDamage / Math.max(integrity, (double)0.01f);
            data.reduceSoulWard(soulWardDamage);
            SoulWardDamageEvent damageEvent = new SoulWardDamageEvent(living, data, source, absorbedDamage, soulWardDamage);
            eventResponders.forEach(lookup -> lookup.run(IMalumEventResponder.class, (eventResponderItem, stack) -> eventResponderItem.soulWardDamageEvent(damageEvent, living, (ItemStack)stack)));
            NeoForge.EVENT_BUS.post((Event)damageEvent);
            DeferredHolder<SoundEvent, SoundEvent> sound = data.getSoulWard() == 0.0 ? MalumSoundEvents.SOUL_WARD_DEPLETE : MalumSoundEvents.SOUL_WARD_HIT;
            SoundHelper.playSound((Entity)living, (SoundEvent)((SoundEvent)sound.get()), (float)1.0f, (float)Mth.nextFloat((RandomSource)living.getRandom(), (float)1.0f, (float)1.5f));
            event.setNewDamage((float)((double)amount - absorbedDamage));
        }
    }
}

