/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe;

import com.sammy.malum.datagen.recipe.MalumRuneworkingRecipes;
import com.sammy.malum.datagen.recipe.MalumSoulbindingRecipes;
import com.sammy.malum.datagen.recipe.MalumSpiritFocusingRecipes;
import com.sammy.malum.datagen.recipe.MalumSpiritRepairRecipes;
import com.sammy.malum.datagen.recipe.MalumUnchainedTransmutationRecipes;
import com.sammy.malum.datagen.recipe.MalumVanillaRecipeReplacements;
import com.sammy.malum.datagen.recipe.MalumVanillaRecipes;
import com.sammy.malum.datagen.recipe.MalumVoidFavorRecipes;
import com.sammy.malum.datagen.recipe.crafting.MalumRockSetDatagen;
import com.sammy.malum.datagen.recipe.crafting.MalumWoodSetDatagen;
import com.sammy.malum.datagen.recipe.infusion.ArtificeSpiritInfusionRecipes;
import com.sammy.malum.datagen.recipe.infusion.CurioSpiritInfusionRecipes;
import com.sammy.malum.datagen.recipe.infusion.GearSpiritInfusionRecipes;
import com.sammy.malum.datagen.recipe.infusion.MaterialSpiritInfusionRecipes;
import com.sammy.malum.datagen.recipe.infusion.MiscSpiritInfusionRecipes;
import com.sammy.malum.datagen.recipe.infusion.TotemicSpiritInfusionRecipes;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class MalumRecipes
extends VanillaRecipeProvider {
    MalumVanillaRecipeReplacements vanillaRecipeReplacements;
    public PackOutput pOutput;

    public MalumRecipes(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(pOutput, registries);
        this.pOutput = pOutput;
        this.vanillaRecipeReplacements = new MalumVanillaRecipeReplacements(pOutput, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput, HolderLookup.Provider holderlookup) {
        this.vanillaRecipeReplacements.buildRecipes(recipeOutput);
        MalumVanillaRecipes.buildRecipes(recipeOutput);
        MalumWoodSetDatagen.buildRecipes(recipeOutput);
        MalumRockSetDatagen.buildRecipes(recipeOutput);
        ArtificeSpiritInfusionRecipes.buildRecipes(recipeOutput);
        CurioSpiritInfusionRecipes.buildRecipes(recipeOutput);
        GearSpiritInfusionRecipes.buildRecipes(recipeOutput);
        MaterialSpiritInfusionRecipes.buildRecipes(recipeOutput);
        TotemicSpiritInfusionRecipes.buildRecipes(recipeOutput);
        MiscSpiritInfusionRecipes.buildRecipes(recipeOutput);
        MalumRuneworkingRecipes.buildRecipes(recipeOutput);
        MalumSpiritFocusingRecipes.buildRecipes(recipeOutput);
        MalumUnchainedTransmutationRecipes.buildRecipes(recipeOutput);
        MalumVoidFavorRecipes.buildRecipes(recipeOutput);
        MalumSpiritRepairRecipes.buildRecipes(recipeOutput);
        MalumSoulbindingRecipes.buildRecipes(recipeOutput);
    }

    public static Criterion<EnterBlockTrigger.TriggerInstance> insideOf(Block block) {
        return CriteriaTriggers.ENTER_BLOCK.createCriterion((CriterionTriggerInstance)new EnterBlockTrigger.TriggerInstance(Optional.empty(), Optional.of(block.builtInRegistryHolder()), Optional.empty()));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(MinMaxBounds.Ints count, ItemLike item) {
        return MalumRecipes.inventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{item}).withCount(count));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike itemLike) {
        return MalumRecipes.inventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{itemLike}));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> tag) {
        return MalumRecipes.inventoryTrigger(ItemPredicate.Builder.item().of(tag));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate.Builder ... items) {
        return MalumRecipes.inventoryTrigger((ItemPredicate[])Arrays.stream(items).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate ... predicates) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(predicates)));
    }
}

