/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.SparkParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class SparkParticleEffects {
    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, MalumSpiritType spiritType) {
        return SparkParticleEffects.spiritMotionSparks(level, pos, spiritType, new WorldParticleOptions(MalumParticles.SPARK));
    }

    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, ColorParticleData colorData) {
        return SparkParticleEffects.spiritMotionSparks(level, pos, colorData, new WorldParticleOptions(MalumParticles.SPARK));
    }

    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, MalumSpiritType spiritType, WorldParticleOptions options) {
        return SparkParticleEffects.spiritMotionSparks(level, pos, options, (WorldParticleOptions o) -> SpiritBasedParticleBuilder.createSpirit(o).setSpirit(spiritType));
    }

    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, ColorParticleData colorData, WorldParticleOptions options) {
        return SparkParticleEffects.spiritMotionSparks(level, pos, options, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setColorData(colorData));
    }

    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, WorldParticleOptions options, Function<WorldParticleOptions, WorldParticleBuilder> builderSupplier) {
        WorldParticleBuilder builder = builderSupplier.apply(options.setBehaviorIfDefault((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior()));
        WorldParticleBuilder bloomBuilder = builderSupplier.apply(new WorldParticleOptions(LodestoneParticleTypes.WISP_PARTICLE));
        return SparkParticleEffects.spiritMotionSparks(level, pos, builder, bloomBuilder);
    }

    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, WorldParticleBuilder builder, WorldParticleBuilder bloomBuilder) {
        RandomSource rand = level.getRandom();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)Mth.nextFloat((RandomSource)rand, (float)0.05f, (float)0.1f)).randomSpinOffset(rand).build();
        Consumer<LodestoneWorldParticle> slowDown = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.95f));
        int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)10, (int)20);
        WorldParticleBuilder sparkParticleBuilder = builder.setLengthData(GenericParticleData.create((float)0.1f, (float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)0.1f, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.2f, (float)0.3f), (float)0.0f).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setTransparencyData(GenericParticleData.create((float)0.8f, (float)0.0f).build()).addTickActor(slowDown).setLifetime(lifetime).enableNoClip();
        WorldParticleBuilder bloomParticleBuilder = SpiritLightSpecs.spiritBloom(level, bloomBuilder, lifetime).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(0.5f)).setSpinData(spinData).addTickActor(slowDown);
        return new ParticleEffectSpawner(level, pos, sparkParticleBuilder, bloomParticleBuilder);
    }
}

