/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.button;

import com.google.gson.annotations.SerializedName;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.OptionalTooltipTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.GuiUtils;

public abstract class ButtonTemplate
extends WidgetElementTemplate {
    private Component text;
    private String icon;
    @SerializedName(value="required_variable")
    private String requiredVariable;
    @SerializedName(value="tooltips")
    private OptionalTooltipTemplate[] tooltips;
    @SerializedName(value="disabled_tooltip")
    private Component disabledTooltip;
    @SerializedName(value="disabled_callback")
    private ElementCallback disabledCallback;

    public ButtonTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public Component getText() {
        return this.text;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getRequiredVariable() {
        return this.requiredVariable;
    }

    public Component getActiveTooltip(VariableStorage variableStorage, boolean isDisabled) {
        if (this.tooltips != null) {
            for (OptionalTooltipTemplate tooltip : this.tooltips) {
                if (!GuiUtils.shouldProcess(tooltip.requiredVariable(), variableStorage)) continue;
                return tooltip.tooltip();
            }
        }
        return isDisabled ? this.disabledTooltip : null;
    }

    public Component getDisabledTooltip() {
        return this.disabledTooltip;
    }

    public ElementCallback getDisabledCallback() {
        return this.disabledCallback;
    }
}

