/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type.text;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.ui.template.element.type.text.TextFormatter;

public class CurrencyFormatter
implements TextFormatter {
    public static CurrencyFormatter INSTANCE = new CurrencyFormatter();

    @Override
    public Component apply(Component component) {
        return TextFormatter.processComponent(component, content -> {
            double amount;
            String[] args = content.split(" ");
            if (args.length != 2) {
                return content;
            }
            if (args[0].isEmpty() || args[1].isEmpty()) {
                return content;
            }
            try {
                amount = Double.parseDouble(args[0]) / 100.0;
            }
            catch (NumberFormatException e) {
                return content;
            }
            String currencyCode = args[1].toUpperCase(Locale.ROOT);
            Currency currency = Currency.getInstance(currencyCode);
            NumberFormat formatter = NumberFormat.getCurrencyInstance();
            formatter.setMaximumFractionDigits(2);
            formatter.setMinimumFractionDigits(2);
            formatter.setCurrency(currency);
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setCurrency(currency);
            return formatter.format(amount);
        });
    }
}

