/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type.text;

import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.rocketplatform.game.client.mod.ui.template.element.type.text.CapitalizationFormatter;
import net.rocketplatform.game.client.mod.ui.template.element.type.text.CurrencyFormatter;
import net.rocketplatform.game.client.mod.ui.template.element.type.text.StorageFormatter;

public interface TextFormatter
extends UnaryOperator<Component> {
    public static final Map<String, TextFormatter> FORMATS = Map.of("capitalization", CapitalizationFormatter.INSTANCE, "currency", CurrencyFormatter.INSTANCE, "storage", StorageFormatter.INSTANCE);

    public static Component processComponent(Component input, UnaryOperator<String> textReplacement) {
        MutableComponent result;
        ComponentContents componentContents = input.getContents();
        if (componentContents instanceof PlainTextContents) {
            PlainTextContents contents = (PlainTextContents)componentContents;
            result = Component.literal((String)((String)textReplacement.apply(contents.text()))).setStyle(input.getStyle());
        } else {
            componentContents = input.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents contents = (TranslatableContents)componentContents;
                Object[] args = new Object[contents.getArgs().length];
                for (int i = 0; i < args.length; ++i) {
                    Object oldArg = contents.getArgs()[i];
                    if (oldArg instanceof Component) {
                        Component component = (Component)oldArg;
                        args[i] = TextFormatter.processComponent(component, textReplacement);
                        continue;
                    }
                    if (oldArg instanceof String) {
                        String str = (String)oldArg;
                        args[i] = textReplacement.apply(str);
                        continue;
                    }
                    args[i] = oldArg;
                }
                result = Component.translatable((String)contents.getKey(), (Object[])args).setStyle(input.getStyle());
            } else {
                return input;
            }
        }
        for (Component sibling : input.getSiblings()) {
            result.append(TextFormatter.processComponent(sibling, textReplacement));
        }
        return result;
    }
}

