/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.api.client.gui.component.io;

import com.daqem.uilib.client.UILibClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public interface IInputValidatable {
    public List<Component> getInputValidationErrors();

    public void setInputValidationErrors(List<Component> var1);

    default public List<Component> validateInput(String input) {
        return new ArrayList<Component>();
    }

    default public boolean hasInputValidationErrors() {
        return !this.getInputValidationErrors().isEmpty();
    }

    default public void clearInputValidationErrors() {
        this.getInputValidationErrors().clear();
    }

    default public void renderInputValidationErrorsTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.hasInputValidationErrors()) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(UILibClient.translatable("gui.text_box.validation_errors").setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED)));
            components.addAll(this.getInputValidationErrors().stream().map(x -> Component.literal((String)"- ").append(x)).toList());
            graphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

