/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui;

import com.daqem.uilib.api.client.gui.IRenderable;
import com.daqem.uilib.api.client.gui.IScreen;
import com.daqem.uilib.api.client.gui.IScreenAccessor;
import com.daqem.uilib.api.client.gui.background.IBackground;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.client.gui.background.Backgrounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreen
extends Screen
implements IScreen {
    private final List<IComponent<?>> components = new ArrayList();
    @Nullable
    private IComponent<?> focusedComponent;
    @Nullable
    private IBackground<?> background = Backgrounds.getDefaultBackground(this.getWidth(), this.getHeight());
    private boolean isPauseScreen = false;

    protected AbstractScreen(Component title) {
        super(title);
    }

    protected AbstractScreen(String title) {
        super((Component)Component.literal((String)title));
    }

    protected void init() {
        super.init();
        if (!this.getAccessor().uilib$isInitialized()) {
            this.startScreen();
            if (this.getBackground() != null) {
                this.getBackground().startRenderable();
            }
            this.getComponents().forEach(IRenderable::startRenderable);
        } else {
            this.onResizeScreenRepositionComponents(this.width, this.height);
            if (this.getBackground() != null) {
                this.getBackground().resizeScreenRepositionRenderable(this.width, this.height);
            }
            this.getComponents().forEach(component -> component.resizeScreenRepositionRenderable(this.width, this.height));
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.checkHovering(mouseX, mouseY, delta);
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        this.renderComponents(guiGraphics, mouseX, mouseY, delta);
        this.onTickScreen(guiGraphics, mouseX, mouseY, delta);
        for (Renderable renderable : this.getAccessor().uilib$getRenderables()) {
            renderable.render(guiGraphics, mouseX, mouseY, delta);
        }
        this.renderTooltips(guiGraphics, mouseX, mouseY, delta);
    }

    private void checkHovering(int mouseX, int mouseY, float delta) {
        this.handleHoverEvent(this.components, mouseX, mouseY, delta);
    }

    private void handleHoverEvent(List<IComponent<?>> components, int mouseX, int mouseY, float delta) {
        for (IComponent<?> component : components) {
            this.handleHoverEvent(component.getChildren(), mouseX, mouseY, delta);
            component.preformOnHoverEvent(mouseX, mouseY, delta);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.background != null) {
            this.background.renderBase(guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void renderComponents(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        for (IComponent<?> component : new ArrayList(this.components)) {
            component.renderBase(guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        for (IComponent<?> component : new ArrayList(this.components)) {
            component.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public List<IComponent<?>> getComponents() {
        return this.components;
    }

    @Override
    @Nullable
    public IComponent<?> getFocusedComponent() {
        return this.focusedComponent;
    }

    @Override
    public void setFocusedComponent(@Nullable IComponent<?> focusedComponent) {
        this.focusedComponent = focusedComponent;
    }

    @Override
    public void addComponent(IComponent<?> component) {
        this.components.add(component);
    }

    @Override
    public void addComponents(IComponent<?> ... components) {
        this.components.addAll(List.of(components));
    }

    @Override
    public void removeComponent(IComponent<?> component) {
        this.components.remove(component);
    }

    @Override
    @Nullable
    public IBackground<?> getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(@Nullable IBackground<?> background) {
        this.background = background;
    }

    @Override
    public void onResizeScreenRepositionComponents(int width, int height) {
        this.repositionComponents(this.components, width, height);
    }

    private void repositionComponents(List<IComponent<?>> components, int width, int height) {
        for (IComponent<?> component : new ArrayList(components)) {
            AbstractScreen.centerComponent(width, height, component);
            this.repositionComponents(component.getChildren(), width - component.getX(), height - component.getY());
        }
    }

    private static void centerComponent(int width, int height, IComponent<?> component) {
        if (component.isCenteredHorizontally()) {
            component.setX(width / 2 - component.getWidth() / 2);
        }
        if (component.isCenteredVertically()) {
            component.setY(height / 2 - component.getHeight() / 2);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.handleClickEvent(this.components, mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean handleClickEvent(List<IComponent<?>> components, double mouseX, double mouseY, int button) {
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleClickEvent(component.getChildren(), mouseX, mouseY, button)) {
                return true;
            }
            if (!component.preformOnClickEvent(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.handleDragEvent(this.components, mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private boolean handleDragEvent(List<IComponent<?>> components, double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleDragEvent(component.getChildren(), mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            if (!component.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.handleScrollEvent(this.components, mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    private boolean handleScrollEvent(List<IComponent<?>> components, double mouseX, double mouseY, double amountX, double amountY) {
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleScrollEvent(component.getChildren(), mouseX, mouseY, amountX, amountY)) {
                return true;
            }
            if (!component.preformOnScrollEvent(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeyPressedEvent(this.components, keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private boolean handleKeyPressedEvent(List<IComponent<?>> components, int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleKeyPressedEvent(component.getChildren(), keyCode, scanCode, modifiers)) {
                handled = true;
                break;
            }
            if (!component.preformOnKeyPressedEvent(keyCode, scanCode, modifiers)) continue;
            handled = true;
            break;
        }
        return handled;
    }

    public boolean charTyped(char c, int i) {
        if (this.handleCharEvent(this.components, c, i)) {
            return true;
        }
        return super.charTyped(c, i);
    }

    private boolean handleCharEvent(List<IComponent<?>> components, char c, int i) {
        boolean handled = false;
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleCharEvent(component.getChildren(), c, i)) {
                handled = true;
                break;
            }
            if (!component.preformOnCharTypedEvent(c, i)) continue;
            handled = true;
            break;
        }
        return handled;
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (this.handleMouseReleaseEvent(this.components, d, e, i)) {
            return true;
        }
        return super.mouseReleased(d, e, i);
    }

    private boolean handleMouseReleaseEvent(List<IComponent<?>> components, double mouseX, double mouseY, int button) {
        for (IComponent<?> component : new ArrayList(components)) {
            if (this.handleMouseReleaseEvent(component.getChildren(), mouseX, mouseY, button)) {
                return true;
            }
            if (!component.preformOnMouseReleaseEvent(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPauseScreen() {
        return this.isPauseScreen;
    }

    @Override
    public void setPauseScreen(boolean pauseScreen) {
        this.isPauseScreen = pauseScreen;
    }

    @Override
    public IScreenAccessor getAccessor() {
        return (IScreenAccessor)((Object)this);
    }
}

