/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component;

import com.daqem.uilib.api.client.gui.IRenderable;
import com.daqem.uilib.api.client.gui.IScreen;
import com.daqem.uilib.api.client.gui.color.IColorManipulator;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.event.OnCharTypedEvent;
import com.daqem.uilib.api.client.gui.component.event.OnClickEvent;
import com.daqem.uilib.api.client.gui.component.event.OnDragEvent;
import com.daqem.uilib.api.client.gui.component.event.OnHoverEvent;
import com.daqem.uilib.api.client.gui.component.event.OnKeyPressedEvent;
import com.daqem.uilib.api.client.gui.component.event.OnMouseReleaseEvent;
import com.daqem.uilib.api.client.gui.component.event.OnScrollEvent;
import com.daqem.uilib.api.client.gui.text.IText;
import com.daqem.uilib.api.client.gui.texture.ITexture;
import com.daqem.uilib.client.gui.color.ColorManipulator;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractComponent<T extends AbstractComponent<T>>
implements IComponent<T> {
    @Nullable
    private IComponent<?> parent;
    private List<IComponent<?>> children = new ArrayList();
    private ITexture texture;
    private int x;
    private int y;
    private int z = 0;
    private int width;
    private int height;
    @Nullable
    private IText<?> text;
    private float scale = 1.0f;
    private float opacity = 1.0f;
    private float rotation = 0.0f;
    private boolean visible = true;
    private boolean centeredHorizontally = false;
    private boolean centeredVertically = false;
    private boolean renderBeforeParent = false;
    @Nullable
    private OnClickEvent<T> onClickEvent;
    @Nullable
    private OnHoverEvent<T> onHoverEvent;
    @Nullable
    private OnDragEvent<T> onDragEvent;
    @Nullable
    private OnScrollEvent<T> onScrollEvent;
    @Nullable
    private OnKeyPressedEvent<T> onKeyPressedEvent;
    @Nullable
    private OnCharTypedEvent<T> onCharTypedEvent;
    @Nullable
    private OnMouseReleaseEvent<T> onMouseReleaseEvent;
    @Nullable
    private T hoverState;
    private IColorManipulator colorManipulator = new ColorManipulator();

    public AbstractComponent(ITexture texture, int x, int y, int width, int height) {
        this.texture = texture;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.hoverState = (AbstractComponent)this.getClone();
    }

    @Override
    public void startRenderable() {
        if (this.getText() != null) {
            this.getText().startRenderable();
        }
        this.getChildren().forEach(IRenderable::startRenderable);
    }

    @Override
    public void resizeScreenRepositionRenderable(int width, int height) {
        if (this.isCenteredHorizontally()) {
            this.centerHorizontally();
        }
        if (this.isCenteredVertically()) {
            this.centerVertically();
        }
        this.getChildren().forEach(child -> child.resizeScreenRepositionRenderable(width, height));
    }

    @Override
    public void renderBase(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isTotalHovered(mouseX, mouseY) && this.hoverState != null && ((AbstractComponent)this.hoverState).isVisible() && this.getOnHoverEvent() != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)((AbstractComponent)this.hoverState).getX(), (float)((AbstractComponent)this.hoverState).getY(), (float)((AbstractComponent)this.hoverState).getZ());
            guiGraphics.pose().scale(((AbstractComponent)this.hoverState).getScale(), ((AbstractComponent)this.hoverState).getScale(), ((AbstractComponent)this.hoverState).getScale());
            guiGraphics.pose().rotateAround(Axis.ZP.rotationDegrees(((AbstractComponent)this.hoverState).getRotation()), (float)((AbstractComponent)this.hoverState).getWidth() / 2.0f, (float)((AbstractComponent)this.hoverState).getHeight() / 2.0f, 0.0f);
            ((AbstractComponent)this.hoverState).getChildren().stream().filter(IComponent::renderBeforeParent).forEach(child -> child.renderBase(guiGraphics, mouseX, mouseY, delta));
            guiGraphics.setColor(((AbstractComponent)this.hoverState).getColorManipulator().getRed(), ((AbstractComponent)this.hoverState).getColorManipulator().getGreen(), ((AbstractComponent)this.hoverState).getColorManipulator().getBlue(), ((AbstractComponent)this.hoverState).getOpacity());
            this.hoverState.render(guiGraphics, mouseX, mouseY, delta);
            ((AbstractComponent)this.hoverState).getChildren().stream().filter(x -> !x.renderBeforeParent()).forEach(child -> child.renderBase(guiGraphics, mouseX, mouseY, delta));
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.pose().popPose();
        } else if (this.isVisible()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), (float)this.getZ());
            guiGraphics.pose().scale(this.getScale(), this.getScale(), this.getScale());
            guiGraphics.pose().rotateAround(Axis.ZP.rotationDegrees(this.getRotation()), (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, 0.0f);
            this.getChildren().stream().filter(IComponent::renderBeforeParent).forEach(child -> child.renderBase(guiGraphics, mouseX, mouseY, delta));
            guiGraphics.setColor(this.getColorManipulator().getRed(), this.getColorManipulator().getGreen(), this.getColorManipulator().getBlue(), this.getOpacity());
            this.render(guiGraphics, mouseX, mouseY, delta);
            this.getChildren().stream().filter(x -> !x.renderBeforeParent()).forEach(child -> child.renderBase(guiGraphics, mouseX, mouseY, delta));
            this.renderText(guiGraphics, mouseX, mouseY, delta);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.pose().popPose();
        }
    }

    @Override
    @Nullable
    public IComponent<?> getParent() {
        return this.parent;
    }

    @Override
    public List<IComponent<?>> getChildren() {
        return this.children;
    }

    @Override
    public ITexture getTexture() {
        return this.texture;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getTotalX() {
        int totalX = this.getX();
        for (IComponent<?> parent = this.getParent(); parent != null; parent = parent.getParent()) {
            totalX += parent.getX();
        }
        return totalX;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getTotalY() {
        int totalY = this.getY();
        for (IComponent<?> parent = this.getParent(); parent != null; parent = parent.getParent()) {
            totalY += parent.getY();
        }
        return totalY;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @Nullable
    public IText<?> getText() {
        return this.text;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public float getOpacity() {
        return this.opacity;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public boolean renderBeforeParent() {
        return this.renderBeforeParent;
    }

    @Override
    public boolean isFocused() {
        IScreen screen;
        Screen screen2 = Minecraft.getInstance().screen;
        return screen2 instanceof IScreen && (screen = (IScreen)screen2).getFocusedComponent() == this;
    }

    @Override
    public void setFocused(boolean focused) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof IScreen) {
            IScreen screen2 = (IScreen)screen;
            screen2.setFocusedComponent(focused ? this : null);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public IColorManipulator getColorManipulator() {
        return this.colorManipulator;
    }

    @Override
    public void setParent(@Nullable IComponent<?> parent, boolean addAsChild) {
        this.parent = parent;
        if (addAsChild && parent != null && !parent.getChildren().contains(this)) {
            parent.addChild(this);
        }
    }

    @Override
    public void setChildren(List<IComponent<?>> children) {
        this.children = children;
        this.children.forEach(child -> child.setParent(this, true));
    }

    @Override
    public void addChild(IComponent<?> child) {
        this.children.add(child);
        child.setParent(this, true);
    }

    @Override
    public void addChildren(IComponent<?> ... children) {
        this.children.addAll(List.of(children));
        this.children.forEach(child -> child.setParent(this, true));
    }

    @Override
    public void addChildren(List<IComponent<?>> children) {
        this.children.addAll(children);
        this.children.forEach(child -> child.setParent(this, true));
    }

    @Override
    public void removeChild(IComponent<?> child) {
        this.children.remove(child);
        child.setParent(null, false);
    }

    @Override
    public void setTexture(ITexture texture) {
        this.texture = texture;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public void setZ(int z) {
        this.z = z;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void setText(@Nullable IText<?> text) {
        this.text = text;
        if (this.text != null) {
            this.text.setParent(this);
        }
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    @Override
    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    @Override
    public void setRenderBeforeParent(boolean renderBeforeParent) {
        this.renderBeforeParent = renderBeforeParent;
    }

    @Override
    public void renderTooltipsBase(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
        this.getChildren().stream().filter(IComponent::renderBeforeParent).forEach(child -> child.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta));
        this.renderTooltips(guiGraphics, mouseX, mouseY, delta);
        this.getChildren().stream().filter(x -> !x.renderBeforeParent()).forEach(child -> child.renderTooltipsBase(guiGraphics, mouseX, mouseY, delta));
        guiGraphics.pose().popPose();
    }

    @Override
    public void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
    }

    @Override
    public void renderText(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.getText() != null) {
            this.getText().renderBase(guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setOnClickEvent(@Nullable OnClickEvent<T> onClickEvent) {
        this.onClickEvent = onClickEvent;
    }

    @Override
    public void setOnHoverEvent(@Nullable OnHoverEvent<T> onHoverEvent) {
        this.onHoverEvent = onHoverEvent;
    }

    @Override
    public void setColorManipulator(IColorManipulator colorManipulator) {
        this.colorManipulator = colorManipulator;
    }

    @Override
    @Nullable
    public OnClickEvent<T> getOnClickEvent() {
        return this.onClickEvent;
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX <= (double)((float)this.getX() + (float)this.getWidth() * this.getScale()) && mouseY >= (double)this.getY() && mouseY <= (double)((float)this.getY() + (float)this.getHeight() * this.getScale());
    }

    @Override
    public boolean isTotalHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.getTotalX() && mouseX <= (double)((float)this.getTotalX() + (float)this.getWidth() * this.getScale()) && mouseY >= (double)this.getTotalY() && mouseY <= (double)((float)this.getTotalY() + (float)this.getHeight() * this.getScale());
    }

    @Override
    @Nullable
    public OnHoverEvent<T> getOnHoverEvent() {
        return this.onHoverEvent;
    }

    @Override
    @Nullable
    public T getHoverState() {
        return this.hoverState;
    }

    @Override
    public void setHoverState(@Nullable T hoverState) {
        this.hoverState = hoverState;
    }

    @Override
    public boolean isCenteredHorizontally() {
        return this.centeredHorizontally;
    }

    @Override
    public boolean isCenteredVertically() {
        return this.centeredVertically;
    }

    @Override
    public boolean isCentered() {
        return this.isCenteredHorizontally() && this.isCenteredVertically();
    }

    @Override
    public void centerHorizontally() {
        int containerWidth = this.getParentWidth();
        int componentWidth = this.getWidth();
        this.setX((int)((float)(containerWidth / 2) - (float)componentWidth * this.scale / 2.0f));
        this.centeredHorizontally = true;
    }

    @Override
    public void centerVertically() {
        int containerHeight = this.getParentHeight();
        int componentHeight = this.getHeight();
        this.setY((int)((float)(containerHeight / 2) - (float)componentHeight * this.scale / 2.0f));
        this.centeredVertically = true;
    }

    @Override
    public void center() {
        this.centerHorizontally();
        this.centerVertically();
    }

    private int getParentWidth() {
        Screen screen = Minecraft.getInstance().screen;
        return this.getParent() != null ? this.getParent().getWidth() : (screen != null ? screen.width : 0);
    }

    private int getParentHeight() {
        Screen screen = Minecraft.getInstance().screen;
        return this.getParent() != null ? this.getParent().getHeight() : (screen != null ? screen.height : 0);
    }

    @Override
    @Nullable
    public Object getClone() {
        try {
            ITexture currentTexture;
            AbstractComponent clone = (AbstractComponent)this.clone();
            IText<?> currentText = this.getText();
            if (currentText != null) {
                clone.setText((IText)currentText.getClone());
            }
            if ((currentTexture = this.getTexture()) != null) {
                clone.setTexture((ITexture)currentTexture.getClone());
            }
            clone.setColorManipulator((IColorManipulator)this.getColorManipulator().getClone());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public OnDragEvent<T> getOnDragEvent() {
        return this.onDragEvent;
    }

    @Override
    public void setOnDragEvent(@Nullable OnDragEvent<T> onDragEvent) {
        this.onDragEvent = onDragEvent;
    }

    @Override
    @Nullable
    public OnScrollEvent<T> getOnScrollEvent() {
        return this.onScrollEvent;
    }

    @Override
    public void setOnScrollEvent(@Nullable OnScrollEvent<T> onScrollEvent) {
        this.onScrollEvent = onScrollEvent;
    }

    @Override
    @Nullable
    public OnKeyPressedEvent<T> getOnKeyPressedEvent() {
        return this.onKeyPressedEvent;
    }

    @Override
    public void setOnKeyPressedEvent(@Nullable OnKeyPressedEvent<T> onKeyPressedEvent) {
        this.onKeyPressedEvent = onKeyPressedEvent;
    }

    @Override
    @Nullable
    public OnCharTypedEvent<T> getOnCharTypedEvent() {
        return this.onCharTypedEvent;
    }

    @Override
    public void setOnCharTypedEvent(@Nullable OnCharTypedEvent<T> onCharTypedEvent) {
        this.onCharTypedEvent = onCharTypedEvent;
    }

    @Override
    @Nullable
    public OnMouseReleaseEvent<T> getOnMouseReleaseEvent() {
        return this.onMouseReleaseEvent;
    }

    @Override
    public void setOnMouseReleaseEvent(@Nullable OnMouseReleaseEvent<T> onMouseReleaseEvent) {
        this.onMouseReleaseEvent = onMouseReleaseEvent;
    }
}

