/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.advancement;

import com.daqem.uilib.api.client.gui.component.advancement.IAdvancement;
import com.daqem.uilib.api.client.gui.component.advancement.IAdvancementTree;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.advancement.AdvancementComponent;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;

public class AdvancementTreeComponent
extends AbstractComponent<AdvancementTreeComponent> {
    public static final int PADDING = 30;
    private final IAdvancementTree advancementTree;
    private AdvancementComponent rootAdvancementComponent;

    public AdvancementTreeComponent(int x, int y, int width, int height, IAdvancementTree advancementTree) {
        super(null, x, y, width, height);
        this.advancementTree = advancementTree;
        this.run();
        int maxWidth = this.getAllAdvancementComponents().stream().mapToInt(AbstractComponent::getTotalX).max().orElse(0) + 26;
        int maxHeight = this.getAllAdvancementComponents().stream().mapToInt(AbstractComponent::getTotalY).max().orElse(0) + 26;
        this.setWidth(maxWidth);
        this.setHeight(maxHeight);
        this.setOnDragEvent((draggedObject, screen, mouseX, mouseY, button, dragX, dragY) -> {
            if (this.getParent() != null) {
                int parentWidth = this.getParent().getWidth();
                int parentHeight = this.getParent().getHeight();
                int newX = this.getX() + (int)dragX;
                int newY = this.getY() + (int)dragY;
                if (newX - 30 <= 0 && newX + this.getWidth() + 30 >= parentWidth) {
                    this.setX(newX);
                }
                if (newY - 30 <= 0 && newY + this.getHeight() + 30 >= parentHeight) {
                    this.setY(newY);
                }
            }
            return false;
        });
    }

    public List<AdvancementComponent> getAllAdvancementComponents() {
        return this.rootAdvancementComponent.getAllAdvancementChildren();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
    }

    public void run() {
        this.advancementTree.getRoot().ifPresent(advancement -> {
            this.rootAdvancementComponent = new AdvancementComponent((IAdvancement)advancement, null, null, 0, this.getX());
            this.addChild(this.rootAdvancementComponent);
            this.rootAdvancementComponent.firstWalk();
            float f = this.rootAdvancementComponent.secondWalk(0.0f, 0, this.rootAdvancementComponent.getY());
            if (f < 0.0f) {
                this.rootAdvancementComponent.thirdWalk(-f);
            }
            this.rootAdvancementComponent.finalizePosition();
        });
    }
}

