/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.arrow;

import com.daqem.uilib.client.gui.component.AbstractComponent;
import net.minecraft.client.gui.GuiGraphics;

public class ArrowComponent
extends AbstractComponent<ArrowComponent> {
    private final Direction direction;
    private final int color;
    private final int size;
    private final int thickness;

    public ArrowComponent(int x, int y, int size, Direction direction, int color, int thickness) {
        super(null, x, y, size, size);
        this.direction = direction;
        this.color = color;
        this.size = size;
        this.thickness = thickness;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        switch (this.direction.ordinal()) {
            case 1: {
                for (int i = 0; i < this.size; ++i) {
                    if (i < this.size / 2) {
                        graphics.hLine(i + this.size / 4 + (this.thickness - 1), i + this.size / 4 - this.thickness / 2, this.size - i - 1, this.color);
                        continue;
                    }
                    graphics.hLine(this.size - i - 1 + this.size / 4 + (this.thickness - 1), this.size - i - 1 + this.size / 4 - this.thickness / 2, this.size - i - 1, this.color);
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.size; ++i) {
                    if (i < this.size / 2) {
                        graphics.hLine(this.size - i - 1 - this.size / 4 - (this.thickness - 1), this.size - i - 1 - this.size / 4 + this.thickness / 2, this.size - i - 1, this.color);
                        continue;
                    }
                    graphics.hLine(i - this.size / 4 - (this.thickness - 1), i - this.size / 4 + this.thickness / 2, this.size - i - 1, this.color);
                }
                break;
            }
        }
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

