/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.io;

import com.daqem.uilib.api.client.gui.component.io.IIOComponent;
import com.daqem.uilib.client.gui.component.AbstractSpriteComponent;
import com.daqem.uilib.client.gui.component.io.IOComponentEntry;
import com.daqem.uilib.client.gui.text.ScrollingText;
import com.daqem.uilib.client.util.SoundManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SliderComponent<T>
extends AbstractSpriteComponent<SliderComponent<T>>
implements IIOComponent<SliderComponent<T>> {
    private final boolean initialized;
    private double doubleValue = 0.0;
    private final List<IOComponentEntry<T>> values;
    private T value;
    private Component prefix;
    private int border = 2;
    private static final LinkedList<ResourceLocation> DEFAULT_SPRITES = new LinkedList<ResourceLocation>(List.of(ResourceLocation.withDefaultNamespace((String)"widget/slider"), ResourceLocation.withDefaultNamespace((String)"widget/slider_handle"), ResourceLocation.withDefaultNamespace((String)"widget/slider_handle_highlighted")));

    public SliderComponent(int x, int y, int width, int height, List<IOComponentEntry<T>> values, T initialValue, Component prefix) {
        this(DEFAULT_SPRITES, x, y, width, height, values, initialValue, prefix);
    }

    public SliderComponent(LinkedList<ResourceLocation> sprites, int x, int y, int width, int height, List<IOComponentEntry<T>> values, T initialValue, Component prefix) {
        super(sprites, x, y, width, height);
        this.values = values;
        this.prefix = prefix;
        this.setValue(initialValue);
        Font font = Minecraft.getInstance().font;
        MutableComponent mutableComponent = Component.empty();
        Objects.requireNonNull(font);
        int n = (height - 9 + 1) / 2;
        Objects.requireNonNull(font);
        ScrollingText text = new ScrollingText(font, (Component)mutableComponent, this.border, n, width - this.border * 2, 9, ScrollingText.Direction.SIDE_TO_SIDE);
        text.setDefaultCentered(true);
        this.setText(text);
        this.setDoubleValue(Mth.clamp((double)this.doubleValue, (double)0.0, (double)1.0));
        this.initialized = true;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        ResourceLocation handleSprite = this.getSprite(1);
        if (this.isTotalHovered(mouseX, mouseY) || this.isFocused()) {
            handleSprite = this.getSprite(2);
        }
        graphics.blitSprite(this.getSprite(0), 0, 0, this.getWidth(), this.getHeight());
        graphics.blitSprite(handleSprite, (int)(this.doubleValue * (double)(this.getWidth() - 8)), 0, 8, this.getHeight());
    }

    @Override
    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        if (this.isTotalHovered(mouseX, mouseY)) {
            this.setValueFromMouse(mouseX);
        }
        return super.preformOnClickEvent(mouseX, mouseY, button);
    }

    @Override
    public boolean preformOnDragEvent(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isTotalHovered(mouseX, mouseY)) {
            this.setValueFromMouse(mouseX);
        }
        return super.preformOnDragEvent(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean preformOnMouseReleaseEvent(double mouseX, double mouseY, int button) {
        if (this.isTotalHovered(mouseX, mouseY)) {
            SoundManager.playUIClick();
        }
        return super.preformOnMouseReleaseEvent(mouseX, mouseY, button);
    }

    private void setValueFromMouse(double d) {
        this.setDoubleValue((d - (double)(this.getTotalX() + 4)) / (double)(this.getWidth() - 8));
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(double doubleValue) {
        double oldValue = this.doubleValue;
        this.doubleValue = Mth.clamp((double)doubleValue, (double)0.0, (double)1.0);
        if (oldValue != this.doubleValue) {
            this.applyValue();
        }
        if (this.getText() != null) {
            this.getText().setText(this.updateMessage());
        }
        if (this.initialized) {
            this.setFocused(true);
        }
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.doubleValue = (double)this.getValueIndex() / (double)(this.values.size() - 1);
        if (this.getText() != null) {
            this.getText().setText(this.updateMessage());
        }
    }

    public IOComponentEntry<T> getEntry() {
        return this.values.stream().filter(entry -> entry.value().equals(this.value)).findFirst().orElse(null);
    }

    @Override
    public String getStringValue() {
        return this.getEntry().stringValue();
    }

    public void applyValue() {
        int size = this.values.size();
        int index = (int)Math.round(this.doubleValue * (double)(size - 1));
        this.value = this.getValueAt(index);
    }

    public int getValueIndex() {
        int index = 0;
        for (IOComponentEntry<T> t : this.values) {
            if (t.value().equals(this.value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public T getValueAt(int index) {
        return this.values.get(index).value();
    }

    public Component updateMessage() {
        return !this.prefix.getString().isEmpty() ? Component.empty().append(this.prefix).append(": ").append(this.getEntry().component()) : this.getEntry().component();
    }
}

