/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.component.scroll;

import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.scroll.IScrollBar;
import com.daqem.uilib.client.gui.component.AbstractNineSlicedComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollPanelComponent;
import com.daqem.uilib.client.gui.texture.NineSlicedTexture;
import java.util.function.BiPredicate;
import net.minecraft.util.Mth;

public class ScrollWheelComponent
extends AbstractNineSlicedComponent<ScrollWheelComponent>
implements IScrollBar {
    private int scrollValue = 0;

    public ScrollWheelComponent(NineSlicedTexture texture, int x, int y, int thickness) {
        super(texture, x, y, thickness, thickness);
    }

    @Override
    public int getMinValue(ScrollPanelComponent scrollPanelComponent) {
        return 0;
    }

    @Override
    public int getMaxValue(ScrollPanelComponent scrollPanelComponent) {
        return scrollPanelComponent.getOffScreenContentLength();
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
    }

    @Override
    public int getScrollValue() {
        return this.scrollValue;
    }

    @Override
    public void setScrollValue(int scrollValue) {
        this.scrollValue = scrollValue;
    }

    @Override
    public int getNextStep(ScrollPanelComponent scrollPanelComponent) {
        if (scrollPanelComponent.getScrollType().isSmooth()) {
            return 1;
        }
        BiPredicate<IComponent<?>, Integer> positionCheck = (component, scrollValue) -> scrollPanelComponent.getScrollOrientation().isHorizontal() ? component.getX() > scrollValue : component.getY() > scrollValue;
        return this.calculateStepValue(scrollPanelComponent, positionCheck, this.getMaxValue(scrollPanelComponent));
    }

    @Override
    public int getPreviousStep(ScrollPanelComponent scrollPanelComponent) {
        if (scrollPanelComponent.getScrollType().isSmooth()) {
            return 1;
        }
        BiPredicate<IComponent<?>, Integer> positionCheck = (component, scrollValue) -> scrollPanelComponent.getScrollOrientation().isHorizontal() ? component.getX() < scrollValue : component.getY() < scrollValue;
        return this.calculateStepValue(scrollPanelComponent, positionCheck, this.getMinValue(scrollPanelComponent));
    }

    @Override
    public int getDimension(boolean isHorizontal) {
        return isHorizontal ? this.getWidth() : this.getHeight();
    }

    private int calculateStepValue(ScrollPanelComponent scrollPanelComponent, BiPredicate<IComponent<?>, Integer> positionCheck, int fallbackValue) {
        return scrollPanelComponent.getScrollContentComponent().map(scrollContentComponent -> scrollContentComponent.getChildren().stream().filter(component -> positionCheck.test((IComponent<?>)component, this.getScrollValue())).findFirst().map(component -> scrollPanelComponent.getScrollOrientation().isHorizontal() ? component.getX() : component.getY()).orElse(fallbackValue)).orElse(0);
    }

    private int getStep(ScrollPanelComponent scrollPanelComponent, double delta) {
        if (delta == 0.0) {
            return 0;
        }
        int stepDirection = delta < 0.0 ? this.getPreviousStep(scrollPanelComponent) : this.getNextStep(scrollPanelComponent);
        int flooredDelta = Mth.floor((double)delta);
        int speedAdjustedDelta = (int)((double)flooredDelta * scrollPanelComponent.getScrollSpeed());
        return speedAdjustedDelta * stepDirection;
    }

    @Override
    public void scroll(ScrollPanelComponent scrollPanelComponent, double amountX, double amountY) {
        double scrollStep = this.getStep(scrollPanelComponent, scrollPanelComponent.getScrollOrientation().isHorizontal() ? amountX : amountY);
        int newScrollPosition = (int)((double)this.getScrollValue() + scrollStep);
        int minValue = this.getMinValue(scrollPanelComponent);
        int maxValue = this.getMaxValue(scrollPanelComponent);
        if (newScrollPosition < minValue) {
            newScrollPosition = minValue;
        } else if (newScrollPosition > maxValue) {
            newScrollPosition = maxValue;
        }
        this.setScrollValue(newScrollPosition);
    }
}

