/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.text;

import com.daqem.uilib.client.gui.text.AbstractText;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TruncatedText
extends AbstractText<TruncatedText> {
    private String ending = "...";

    public TruncatedText(Font font, Component text, int x, int y) {
        super(font, text, x, y);
    }

    public TruncatedText(Font font, Component text, int x, int y, int width, int height) {
        super(font, text, x, y, width, height);
    }

    public TruncatedText(Font font, Component text, int x, int y, String ending) {
        super(font, text, x, y);
        this.ending = ending;
    }

    public TruncatedText(Font font, Component text, int x, int y, int width, int height, String ending) {
        super(font, text, x, y, width, height);
        this.ending = ending;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int width;
        Font font;
        Component text = this.getText();
        if (this.textExceedsWidth(text, font = this.getFont(), width = this.getWidth())) {
            text = this.trimTextToFitWidth(text, font, width);
            this.setText(text);
        }
        this.renderText(graphics);
    }

    private boolean textExceedsWidth(Component text, Font font, int width) {
        return font.width((FormattedText)text) > width;
    }

    private Component trimTextToFitWidth(Component text, Font font, int width) {
        text = text.plainCopy().append(this.ending).withStyle(style -> this.getText().getStyle());
        while (font.width((FormattedText)text) > width && text.getString().length() > 1 + this.ending.length()) {
            String trimmedText = text.getString().substring(0, text.getString().length() - (1 + this.ending.length()));
            text = Component.literal((String)trimmedText).append(this.ending).withStyle(style -> this.getText().getStyle());
        }
        return text;
    }

    private void renderText(GuiGraphics graphics) {
        graphics.drawString(this.getFont(), this.getText(), 0, 0, this.getTextColor(), this.isShadow());
    }

    public String getEnding() {
        return this.ending;
    }

    public void setEnding(String ending) {
        this.ending = ending;
    }
}

