/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.client.gui.text.multiline;

import com.daqem.uilib.client.gui.text.AbstractText;
import com.daqem.uilib.client.gui.text.multiline.MultiLineUtils;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class MultiLineText
extends AbstractText<MultiLineText> {
    private int maxWidth;
    private boolean hasChange = false;
    private List<FormattedCharSequence> lines;

    public MultiLineText(Font font, Component text, int x, int y, int maxWidth) {
        super(font, text, x, y);
        this.maxWidth = maxWidth;
        this.lines = this.getVisualOrder(this.findOptimalLines(font, text, maxWidth));
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.hasChange) {
            List<FormattedText> optimalLines = this.findOptimalLines(this.getFont(), this.getText(), this.getMaxWidth());
            this.setLines(this.getVisualOrder(optimalLines));
            this.hasChange = false;
        }
        for (int i1 = 0; i1 < this.getLines().size(); ++i1) {
            FormattedCharSequence line = this.getLines().get(i1);
            graphics.drawString(this.getFont(), line, 0, i1 * 9, 0, false);
        }
    }

    private List<FormattedText> findOptimalLines(Font font, Component text, int maxWidth) {
        return MultiLineUtils.findOptimalLines(font, text, maxWidth);
    }

    private List<FormattedCharSequence> getVisualOrder(List<FormattedText> lines) {
        return Language.getInstance().getVisualOrder(lines);
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.hasChange = true;
    }

    @Override
    public void setText(Component text) {
        super.setText(text);
        this.hasChange = true;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.hasChange = true;
    }

    public List<FormattedCharSequence> getLines() {
        return this.lines;
    }

    public void setLines(List<FormattedCharSequence> lines) {
        this.lines = lines;
    }
}

