/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.item;

import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;

public class ContainerToItemContainerAdapter
implements ItemContainer {
    private final Container container;

    public ContainerToItemContainerAdapter(Container container) {
        this.container = container;
    }

    @Override
    public int size() {
        return this.container.getContainerSize();
    }

    @Override
    @NotNull
    public ItemStack get(int slot) {
        return this.container.getItem(slot);
    }

    @Override
    public void set(int slot, @Nonnull @NotNull ItemStack stack) {
        this.container.setItem(slot, stack);
    }

    @Override
    public boolean isValid(int slot, @NotNull ItemStack stack) {
        return this.container.canPlaceItem(slot, stack);
    }

    @Override
    public int getSlotCapacity(int slot) {
        return this.container.getMaxStackSize();
    }

    @Override
    public void clear() {
        this.container.clearContent();
    }

    @Override
    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    @Override
    @Nonnull
    @NotNull
    public Container asVanillaContainer() {
        return this.container;
    }
}

