/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.item;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;

public class ItemContainerSlice
implements ItemContainer {
    private final ItemContainer parent;
    private final int from;
    private final int size;

    public ItemContainerSlice(ItemContainer parent, int from, int size) {
        this.parent = parent;
        this.from = from;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public ItemStack get(int slot) {
        Objects.checkIndex(slot, this.size);
        return this.parent.get(slot + this.from);
    }

    @Override
    public void set(int slot, @Nonnull @NotNull ItemStack stack) {
        Objects.checkIndex(slot, this.size);
        this.parent.set(slot + this.from, stack);
    }

    @Override
    public boolean isValid(int slot, @NotNull ItemStack stack) {
        Objects.checkIndex(slot, this.size);
        return this.parent.isValid(slot + this.from, stack);
    }

    @Override
    public int getSlotCapacity(int slot) {
        return this.parent.getSlotCapacity(slot + this.from);
    }

    @Override
    @NotNull
    public ItemContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new ItemContainerSlice(this.parent, this.from + from, to - from);
    }
}

