/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.builder;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import tv.soaryn.xycraft.core.content.FluidContent;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.content.builder.RegistrationContentBuilder;
import tv.soaryn.xycraft.core.content.fluids.XyFluidType;

public class FluidContentRegistrationBuilder
extends RegistrationContentBuilder<FluidContentRegistrationBuilder, FluidContent> {
    private Function<FluidType.Properties, XyFluidType> _fluidTypeFactory = XyFluidType::new;
    private Function<BaseFlowingFluid.Properties, BaseFlowingFluid.Source> _sourceFactory = BaseFlowingFluid.Source::new;
    private Function<BaseFlowingFluid.Properties, BaseFlowingFluid.Flowing> _flowingFactory = BaseFlowingFluid.Flowing::new;
    private Function<String, FluidType.Properties> _fluidTypeProperties = name -> FluidType.Properties.create().descriptionId(name);
    private Consumer<BaseFlowingFluid.Properties> fluidProperties = properties -> {};
    private BaseFlowingFluid.Properties _tempProperties;

    public static FluidContentRegistrationBuilder begin(Class<?> callingClass, ContentMap map, Function<FluidType.Properties, XyFluidType> factory) {
        return new FluidContentRegistrationBuilder(map, map.getContentId(callingClass), factory);
    }

    protected FluidContentRegistrationBuilder(ContentMap map, String contentId, Function<FluidType.Properties, XyFluidType> factory) {
        super(map, contentId);
        this._fluidTypeFactory = factory;
    }

    public FluidContentRegistrationBuilder withSource(Function<BaseFlowingFluid.Properties, BaseFlowingFluid.Source> factory) {
        this._sourceFactory = factory;
        return this;
    }

    public FluidContentRegistrationBuilder withFlowing(Function<BaseFlowingFluid.Properties, BaseFlowingFluid.Flowing> factory) {
        this._flowingFactory = factory;
        return this;
    }

    public FluidContentRegistrationBuilder withTypeProperties(Function<String, FluidType.Properties> properties) {
        this._fluidTypeProperties = properties;
        return this;
    }

    public FluidContentRegistrationBuilder withFluidProperties(Consumer<BaseFlowingFluid.Properties> consumer) {
        this.fluidProperties = consumer;
        return this;
    }

    @Override
    public FluidContent build() {
        DeferredHolder typeRef = this._map.FluidTypeMap.register(this.Id, () -> this._fluidTypeFactory.apply(this._fluidTypeProperties.apply("xycraft_machines.fluid." + this.Id)).setStillResource(ResourceLocation.fromNamespaceAndPath((String)this._map.ModId, (String)("block/fluids/" + this.Id))).setFlowResource(ResourceLocation.fromNamespaceAndPath((String)this._map.ModId, (String)("block/fluids/" + this.Id + "_flowing"))));
        DeferredHolder sourceRef = this._map.FluidMap.register(this.Id, () -> this._sourceFactory.apply(this._tempProperties));
        DeferredHolder flowingRef = this._map.FluidMap.register("flowing_" + this.Id, () -> this._flowingFactory.apply(this._tempProperties));
        this._tempProperties = new BaseFlowingFluid.Properties((Supplier)typeRef, (Supplier)sourceRef, (Supplier)flowingRef);
        if (this.fluidProperties != null) {
            this.fluidProperties.accept(this._tempProperties);
        }
        FluidContent content = new FluidContent((DeferredHolder<FluidType, XyFluidType>)typeRef, (DeferredHolder<Fluid, BaseFlowingFluid.Source>)sourceRef, (DeferredHolder<Fluid, BaseFlowingFluid.Flowing>)flowingRef);
        content.requires(this._requirement);
        this._map.MappedContent.add(content);
        this._localizations.forEach((mcLocale, name) -> content.withName(mcLocale.toString(), (String)name));
        return content;
    }
}

