/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.builder;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.TorchBlockContent;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.content.builder.RegistrationContentBuilder;
import tv.soaryn.xycraft.core.datagen.BlockModelType;

public class TorchBlockContentRegistrationBuilder
extends RegistrationContentBuilder<TorchBlockContentRegistrationBuilder, TorchBlockContent> {
    private Supplier<BlockBehaviour.Properties> _blockProperties = BlockBehaviour.Properties::of;
    private Supplier<Item.Properties> _itemProperties = Item.Properties::new;
    private final BiFunction<BlockBehaviour.Properties, DeferredHolder<ParticleType<?>, ? extends ParticleType<?>>, Block> _blockFactory;
    private final BiFunction<BlockBehaviour.Properties, DeferredHolder<ParticleType<?>, ? extends ParticleType<?>>, Block> _wallBlockFactory;
    private PropertyDispatch.TriFunction<DeferredBlock<Block>, DeferredBlock<Block>, Item.Properties, Item> _itemBlockFactory = (block, wall, item) -> new StandingAndWallBlockItem((Block)block.get(), (Block)wall.get(), item, Direction.DOWN);
    private BlockModelType _model = BlockModelType.Simple;
    protected DeferredHolder<CreativeModeTab, CreativeModeTab> Tab;
    private Supplier<DeferredHolder<ParticleType<?>, ? extends ParticleType<?>>> _particle;

    public TorchBlockContentRegistrationBuilder(ContentMap map, String contentId, BiFunction<BlockBehaviour.Properties, DeferredHolder<ParticleType<?>, ? extends ParticleType<?>>, Block> factory, BiFunction<BlockBehaviour.Properties, DeferredHolder<ParticleType<?>, ? extends ParticleType<?>>, Block> wallFactory) {
        super(map, contentId);
        this._blockFactory = factory;
        this._wallBlockFactory = wallFactory;
    }

    public TorchBlockContentRegistrationBuilder withTab(@Nullable DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        this.Tab = tab;
        return this;
    }

    public TorchBlockContentRegistrationBuilder withBlockProperties(Supplier<BlockBehaviour.Properties> properties) {
        this._blockProperties = properties;
        return this;
    }

    public TorchBlockContentRegistrationBuilder withBlockPropertiesFrom(Supplier<Block> backingBlock) {
        this._blockProperties = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)backingBlock.get()));
        return this;
    }

    public TorchBlockContentRegistrationBuilder withItemProperties(Supplier<Item.Properties> itemProperties) {
        this._itemProperties = itemProperties;
        return this;
    }

    public TorchBlockContentRegistrationBuilder withItem(PropertyDispatch.TriFunction<DeferredBlock<Block>, DeferredBlock<Block>, Item.Properties, Item> item) {
        this._itemBlockFactory = item;
        return this;
    }

    public TorchBlockContentRegistrationBuilder withModelType(BlockModelType model) {
        this._model = model;
        return this;
    }

    @Override
    public TorchBlockContent build() {
        DeferredBlock blockRef = this._map.BlockMap.register(this.Id, () -> this._blockFactory.apply(this._blockProperties.get(), this._particle.get()));
        DeferredBlock wallRef = this._map.BlockMap.register(this.Id + "_wall", () -> this._wallBlockFactory.apply(this._blockProperties.get().lootFrom((Supplier)blockRef), this._particle.get()));
        DeferredItem registryItem = this._map.ItemMap.register(this.Id, () -> (Item)this._itemBlockFactory.apply((Object)blockRef, (Object)wallRef, (Object)this._itemProperties.get()));
        TorchBlockContent content = new TorchBlockContent((DeferredBlock<Block>)blockRef, (DeferredBlock<Block>)wallRef, (DeferredItem<Item>)registryItem);
        this._map.ListOfBlocks.add(content);
        this._map.MappedContent.add(content);
        content.setTab((DeferredHolder)this.Tab);
        content.withModelType(this._model);
        content.requires(this._requirement);
        this._localizations.forEach((mcLocale, name) -> content.withName(mcLocale.toString(), (String)name));
        return content;
    }

    public TorchBlockContentRegistrationBuilder withParticle(Supplier<DeferredHolder<ParticleType<?>, ? extends ParticleType<?>>> particle) {
        this._particle = particle;
        return this;
    }
}

