/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.capabilities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.IWrenchHandler;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;

@EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.GAME)
public interface WrenchCapability {
    public static final ItemAbility Wrench = ItemAbility.get((String)"wrench");

    public static IWrenchHandler of(Level level, BlockPos pos) {
        return (IWrenchHandler)level.getCapability(CoreCapabilities.WrenchBlock.BLOCK, pos, null);
    }

    public static boolean isValidToolInMainHand(@NotNull Player player, InteractionHand hand, boolean canBeEmptyHand) {
        ItemStack stack = player.getItemInHand(hand);
        return stack.canPerformAction(Wrench) || stack.is(XyCraftTags.Items.XyActuator.tag()) || ModifierKey.of(player) && player.getMainHandItem().isEmpty() && canBeEmptyHand;
    }

    public static IWrenchHandler registerCommonRotate(Level level, BlockPos pos, BlockState ignored1, @Nullable BlockEntity ignored2, Void ignored13) {
        return (player, interactionHand, hitResult) -> WrenchCapability.rotate(player, level, level.getBlockState(pos), pos, hitResult);
    }

    public static InteractionResult rotate(Player player, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull BlockHitResult hit) {
        Direction currentDirection = (Direction)state.getValue(CoreStateProperties.StateDirection);
        Direction targeted = hit.getDirection();
        if (targeted != currentDirection && targeted != currentDirection.getOpposite()) {
            Direction.AxisDirection axisDirection = targeted.getAxisDirection();
            if (player.isShiftKeyDown()) {
                axisDirection = axisDirection.opposite();
            }
            Direction dir = axisDirection == Direction.AxisDirection.NEGATIVE ? currentDirection.getCounterClockWise(targeted.getAxis()) : currentDirection.getClockWise(targeted.getAxis());
            BlockState newState = (BlockState)state.setValue(CoreStateProperties.StateDirection, (Comparable)dir);
            level.setBlock(pos, newState, 11);
            level.markAndNotifyBlock(pos, level.getChunkAt(pos), newState, state, 3, 512);
            level.invalidateCapabilities(pos);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return null;
    }

    @SubscribeEvent
    public static void rightClickWithWrench(PlayerInteractEvent.RightClickBlock event) {
        IWrenchHandler cap = WrenchCapability.of(event.getLevel(), event.getPos());
        if (cap == null) {
            return;
        }
        if (!WrenchCapability.isValidToolInMainHand(event.getEntity(), event.getHand(), cap.canBeEmptyHand())) {
            return;
        }
        InteractionResult result = cap.onWrenchUsed(event.getEntity(), event.getHand(), event.getHitVec());
        if (result == null) {
            return;
        }
        event.setUseItem(TriState.TRUE);
        event.setUseBlock(TriState.FALSE);
        event.setCancellationResult(result);
        event.setCanceled(true);
    }
}

