/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.fluids;

import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.builder.ContentMap;

@EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.MOD)
public class XyFluidType
extends FluidType {
    private ResourceLocation StillResource;
    private ResourceLocation FlowingResource;

    public XyFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public static XyFluidType supplier(String name) {
        return new XyFluidType(FluidType.Properties.create().descriptionId(name));
    }

    public XyFluidType setStillResource(ResourceLocation resource) {
        this.StillResource = resource;
        return this;
    }

    public XyFluidType setFlowResource(ResourceLocation resource) {
        this.FlowingResource = resource;
        return this;
    }

    @SubscribeEvent
    private static void initializeClient(RegisterClientExtensionsEvent event) {
        for (final XyFluidType fluid : ContentMap.getFluids()) {
            event.registerFluidType(new IClientFluidTypeExtensions(){

                @NotNull
                public ResourceLocation getStillTexture() {
                    return fluid.StillResource;
                }

                @NotNull
                public ResourceLocation getFlowingTexture() {
                    return fluid.FlowingResource;
                }
            }, new FluidType[]{fluid});
        }
    }
}

