/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.mixins;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.content.blocks.IFluidSpreadPreventer;

@Mixin(value={FlowingFluid.class})
public class FlowingFluidMixin {
    @Inject(method={"canSpreadTo"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canSpreadTo(BlockGetter level, BlockPos srcPos, BlockState state, Direction direction, BlockPos dstPos, BlockState dstState, FluidState fluidState, Fluid fluid, CallbackInfoReturnable<Boolean> cir) {
        for (Direction d : Direction.values()) {
            BlockPos pos = dstPos.relative(d);
            Block block = level.getBlockState(pos).getBlock();
            if (block instanceof IFluidSpreadPreventer) {
                IFluidSpreadPreventer preventer = (IFluidSpreadPreventer)block;
                cir.setReturnValue((Object)preventer.allowFluidFlow(level, srcPos, state, direction, dstPos, dstState, fluidState, fluid));
                cir.cancel();
                continue;
            }
            if (!level.getBlockState(pos).is(XyCraftTags.Blocks.FluidVoid.tag())) continue;
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }
}

