/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.network;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;

public final class NetworkHandler {
    private final String namespace;
    private final String version;
    private final Map<Class<? extends Packet>, PacketType<?>> packetTypes;

    private NetworkHandler(String namespace, String version, Map<Class<? extends Packet>, PacketType<?>> packetTypes) {
        this.namespace = namespace;
        this.version = version;
        this.packetTypes = packetTypes;
    }

    private <T extends Packet> PacketWrapper<T> wrap(T packet) {
        PacketType<?> packetType = this.packetTypes.get(packet.getClass());
        return new PacketWrapper(packetType, packet);
    }

    public void setup(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(this.namespace).versioned(this.version);
        this.packetTypes.forEach((packetClass, type) -> registrar.playBidirectional(type.payloadType, type.serdes.asStreamCodec(), (packetWrapper, playPayloadContext) -> {
            Object patt0$temp = packetWrapper.packet();
            if (patt0$temp instanceof Packet.ClientBound) {
                Packet.ClientBound clientBound = (Packet.ClientBound)patt0$temp;
                clientBound.handle(new Builder.Context.Client(this, playPayloadContext));
            } else {
                Object patt1$temp = packetWrapper.packet();
                if (patt1$temp instanceof Packet.ServerBound) {
                    Packet.ServerBound serverBound = (Packet.ServerBound)patt1$temp;
                    serverBound.handle(new Builder.Context.Server(this, playPayloadContext));
                }
            }
        }));
    }

    public void send(Packet.ServerBound packet) {
        PacketDistributor.sendToServer(this.wrap(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void send(Player player, Packet.ClientBound packet) {
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalArgumentException("The player must be a ServerPlayer.");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, this.wrap(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void broadcast(Packet.ClientBound packet) {
        PacketDistributor.sendToAllPlayers(this.wrap(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void broadcast(Level level, Packet.ClientBound packet) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalArgumentException("The level must be a ServerLevel.");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, this.wrap(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void broadcast(Level level, ChunkPos pos, Packet.ClientBound packet) {
        if (!level.isLoaded(pos.getWorldPosition()) || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)pos, this.wrap(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void broadcast(Level level, BlockPos pos, Packet.ClientBound packet) {
        if (!level.isLoaded(pos) || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), this.wrap(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static Builder builder(String namespace, String version) {
        return new Builder(namespace, version);
    }

    private static final class PacketType<T extends Packet> {
        public final CustomPacketPayload.Type<PacketWrapper<T>> payloadType;
        public final ResourceLocation id;
        public final BinarySerializer<PacketWrapper<T>> serdes;

        public PacketType(ResourceLocation id, BinarySerializer<T> serDes) {
            this.id = id;
            this.payloadType = new CustomPacketPayload.Type(id);
            this.serdes = serDes.map(PacketWrapper::packet, p -> new PacketWrapper<Packet>(this, (Packet)p));
        }
    }

    private record PacketWrapper<T extends Packet>(PacketType<T> packetType, T packet) implements CustomPacketPayload
    {
        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return this.packetType.payloadType;
        }
    }

    public static final class Builder {
        private final Map<Class<? extends Packet>, PacketType<?>> packetTypes = new IdentityHashMap();
        private final String namespace;
        private final String version;

        public Builder(String namespace, String version) {
            this.namespace = namespace;
            this.version = version;
        }

        public <T extends Packet> Builder register(String name, Class<T> packet, BinarySerializer<T> serdes) {
            this.packetTypes.put(packet, new PacketType<T>(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)name), serdes));
            return this;
        }

        public NetworkHandler build() {
            return new NetworkHandler(this.namespace, this.version, this.packetTypes);
        }

        private static abstract sealed class Context
        implements Packet.Context {
            protected final NetworkHandler networkHandler;
            protected final IPayloadContext source;

            private Context(NetworkHandler networkHandler, IPayloadContext source) {
                this.networkHandler = networkHandler;
                this.source = source;
            }

            @Override
            public NetworkHandler networkHandler() {
                return this.networkHandler;
            }

            @Override
            public IPayloadContext source() {
                return this.source;
            }

            @Override
            public void enqueueMainThread(Runnable runnable) {
                this.source.enqueueWork(runnable);
            }

            private static final class Server
            extends Context
            implements Packet.ServerBound.Context {
                private Server(NetworkHandler networkHandler, IPayloadContext source) {
                    super(networkHandler, source);
                }

                @Override
                public ServerPlayer player() {
                    return (ServerPlayer)this.source.player();
                }
            }

            private static final class Client
            extends Context
            implements Packet.ClientBound.Context {
                private Client(NetworkHandler networkHandler, IPayloadContext source) {
                    super(networkHandler, source);
                }

                @Override
                public Player player() {
                    return Utils.getClientPlayer();
                }
            }
        }
    }
}

