/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.Util;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.MapColor;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.attachments.accessors.Ticks;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.DyeColors;

public final class ColorUtils {
    private static final Int2ObjectMap<IColorSource> _dyeMap = (Int2ObjectMap)Util.make(() -> {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (IColorSource dye : Dye.All) {
            if (dye == Dye.LightBlue) {
                map.put(3847130, (Object)dye);
                continue;
            }
            map.put(dye.getColor(), (Object)dye);
        }
        return map;
    });

    private ColorUtils() {
    }

    public static DyeColors getClosestDyeColor(int color, DyeColors defaultColor) {
        DyeColors closest = defaultColor;
        double currentDif = 2.147483647E9;
        Vector3f colorVec = ColorUtils.convertToRGBVec(color);
        for (DyeColor materialColor : DyeColor.values()) {
            Vector3f materialColorVec = ColorUtils.convertToRGBVec(ColorUtils.getColorFromDye(materialColor));
            double distance = colorVec.distance((Vector3fc)materialColorVec);
            if (!(distance < currentDif)) continue;
            currentDif = distance;
            closest = DyeColors.from(materialColor);
        }
        return closest;
    }

    public static IColorSource getDyeFromColor(int value) {
        return (IColorSource)_dyeMap.getOrDefault(value, (Object)Dye.White);
    }

    public static int getColorFromDyeNoCorrection(DyeColor color) {
        return color.getTextureDiffuseColor();
    }

    public static int getColorFromDye(DyeColor color) {
        return switch (color) {
            case DyeColor.LIGHT_BLUE -> -10318081;
            case DyeColor.PURPLE -> -5618467;
            default -> ColorUtils.getColorFromDyeNoCorrection(color);
        };
    }

    public static int getColorTime(int offset) {
        return ColorUtils.getColorTime(offset, 10000);
    }

    public static int getColorTime(int offset, int speed) {
        return ColorUtils.HSBtoFRGB((float)((Ticks.ofClient() + (long)offset) % (long)speed) / (float)speed, 1.0f, 1.0f);
    }

    public static Vector4f RGBAtoHSVA(Vector4f rgba) {
        return ColorUtils.RGBAtoHSVA((int)(rgba.x * 255.0f), (int)(rgba.y * 255.0f), (int)(rgba.z * 255.0f), (int)(rgba.w * 255.0f));
    }

    public static Vector4f ARGBtoHSVA(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return ColorUtils.RGBAtoHSVA(r, g, b, a);
    }

    public static Vector4f RGBAtoHSVA(int r, int g, int b, int a) {
        float hue;
        int cmin;
        int cmax = Math.max(r, g);
        if (b > cmax) {
            cmax = b;
        }
        if (b < (cmin = Math.min(r, g))) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new Vector4f(hue, saturation, brightness, (float)a / 255.0f);
    }

    public static int HSBtoFRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static Vector3f convertToRGBVec(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Vector3f(r, g, b);
    }

    public static Vector4f convertToRGBAVec(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Vector4f(r, g, b, a);
    }

    public static int convertToFRGB(Vector3f rgb) {
        return 0xFF000000 | (int)(rgb.x * 255.0f) << 16 | (int)(rgb.y * 255.0f) << 8 | (int)(rgb.z * 255.0f);
    }

    public static int convertToARGB(Vector4f rgba) {
        return (int)(rgba.w() * 255.0f) << 24 | (int)(rgba.x() * 255.0f) << 16 | (int)(rgba.y() * 255.0f) << 8 | (int)(rgba.z() * 255.0f);
    }

    public static int lerp(int current, int targetColor, float stepAmount) {
        Vector4f targetVec = ColorUtils.convertToRGBAVec(targetColor);
        Vector4f currentVec = ColorUtils.convertToRGBAVec(current);
        currentVec.lerp((Vector4fc)targetVec, stepAmount);
        if ((double)currentVec.distanceSquared((Vector4fc)targetVec) < 0.002) {
            return targetColor;
        }
        int n = 2;
        return ColorUtils.convertToARGB(currentVec);
    }

    public static boolean lerp(Vector4f current, Vector4f target, float stepAmount) {
        if (target.distanceSquared((Vector4fc)current) > 1.0E-5f) {
            current.lerp((Vector4fc)target, stepAmount);
            return true;
        }
        return false;
    }

    public static Vector4f lerpHSVA(Vector4f current, Vector4f target, float t) {
        float hue;
        Vector4f a = new Vector4f((Vector4fc)current);
        Vector4f b = new Vector4f((Vector4fc)target);
        float delta = b.x - a.x;
        if (delta < 0.0f) {
            delta += 1.0f;
        }
        if (delta > 0.5f) {
            delta -= 1.0f;
        }
        if ((hue = (a.x + delta * t) % 1.0f) < 0.0f) {
            hue += 1.0f;
        }
        return new Vector4f(hue, a.y + t * (b.y - a.y), a.z + t * (b.z - a.z), a.w + t * (b.w - a.w));
    }

    public static int multiply(int color, float intensity) {
        Vector3f rgb = ColorUtils.convertToRGBVec(color).mul(intensity, intensity, intensity);
        return ColorUtils.convertToFRGB(rgb);
    }

    public static int swizzle(int color, int mask) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Vector4f v = new Vector4f(r, g, b, a);
        return (int)(v.get(mask >> 12 & 0xF) * 255.0f) << 24 | (int)(v.get(mask >> 8 & 0xF) * 255.0f) << 16 | (int)(v.get(mask >> 4 & 0xF) * 255.0f) << 8 | (int)(v.get(mask & 0xF) * 255.0f);
    }

    public static Vector3i toVec3i(Vector3f vector) {
        return new Vector3i((Vector3fc)vector, 0);
    }

    public static MapColor getMaterialColor(XyCraftColors color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case XyCraftColors.Blue -> MapColor.COLOR_BLUE;
            case XyCraftColors.Red -> MapColor.COLOR_RED;
            case XyCraftColors.Green -> MapColor.COLOR_GREEN;
            case XyCraftColors.Light -> MapColor.TERRACOTTA_WHITE;
            case XyCraftColors.Dark -> MapColor.COLOR_GRAY;
        };
    }

    public static interface Dye {
        public static final IColorSource White = new ColorSource.Dye(DyeColor.WHITE);
        public static final IColorSource Orange = new ColorSource.Dye(DyeColor.ORANGE);
        public static final IColorSource Magenta = new ColorSource.Dye(DyeColor.MAGENTA);
        public static final IColorSource LightBlue = new ColorSource.Dye(DyeColor.LIGHT_BLUE);
        public static final IColorSource Yellow = new ColorSource.Dye(DyeColor.YELLOW);
        public static final IColorSource Lime = new ColorSource.Dye(DyeColor.LIME);
        public static final IColorSource Pink = new ColorSource.Dye(DyeColor.PINK);
        public static final IColorSource Gray = new ColorSource.Dye(DyeColor.GRAY);
        public static final IColorSource LightGray = new ColorSource.Dye(DyeColor.LIGHT_GRAY);
        public static final IColorSource Cyan = new ColorSource.Dye(DyeColor.CYAN);
        public static final IColorSource Purple = new ColorSource.Dye(DyeColor.PURPLE);
        public static final IColorSource Blue = new ColorSource.Dye(DyeColor.BLUE);
        public static final IColorSource Brown = new ColorSource.Dye(DyeColor.BROWN);
        public static final IColorSource Green = new ColorSource.Dye(DyeColor.GREEN);
        public static final IColorSource Red = new ColorSource.Dye(DyeColor.RED);
        public static final IColorSource Black = new ColorSource.Dye(DyeColor.BLACK);
        public static final IColorSource[] All = new IColorSource[]{White, Orange, Magenta, LightBlue, Yellow, Lime, Pink, Gray, LightGray, Cyan, Purple, Blue, Brown, Green, Red, Black};
    }
}

