/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.profiler;

import com.google.common.base.Stopwatch;
import java.time.Duration;

public record ProfileMarker(String name, Stopwatch stopwatch) {
    public static ProfileMarker of(String name) {
        return new ProfileMarker(name, Stopwatch.createStarted());
    }

    public void begin() {
        this.stopwatch.reset();
        this.stopwatch.start();
    }

    public Duration elapsed() {
        return this.stopwatch.elapsed();
    }

    public void end() {
        if (this.stopwatch.isRunning()) {
            this.stopwatch.stop();
        }
    }

    public String differenceInTime(ProfileMarker other) {
        Duration elapsed = other.elapsed().minus(this.elapsed());
        return "%s: %d.%dms".formatted(this.name, elapsed.toMillis(), elapsed.toMillisPart());
    }

    @Override
    public String toString() {
        Duration elapsed = this.elapsed();
        return "%s: %d.%dms".formatted(this.name, elapsed.toMillis(), elapsed.toMillisPart());
    }
}

