/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.protocontainer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import tv.soaryn.xycraft.core.utils.protocontainer.IResource;

public record ResourceStack<T extends IResource>(T resource, int amount) {
    public ResourceStack {
        Objects.requireNonNull(resource, "resource");
    }

    public static <B extends FriendlyByteBuf, T extends IResource> StreamCodec<B, ResourceStack<T>> streamCodec(StreamCodec<? super B, T> resourceCodec) {
        return StreamCodec.composite(resourceCodec, ResourceStack::resource, (StreamCodec)ByteBufCodecs.VAR_INT, ResourceStack::amount, ResourceStack::new);
    }

    public static <T extends IResource> Codec<ResourceStack<T>> codec(Codec<T> resourceCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)resourceCodec.fieldOf("resource").forGetter(ResourceStack::resource), (App)Codec.INT.fieldOf("amount").forGetter(ResourceStack::amount)).apply((Applicative)instance, ResourceStack::new));
    }

    public static <T extends IResource> Codec<ResourceStack<T>> flatCodec(MapCodec<T> resourceCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)resourceCodec.forGetter(ResourceStack::resource), (App)Codec.INT.fieldOf("amount").forGetter(ResourceStack::amount)).apply((Applicative)instance, ResourceStack::new));
    }

    public boolean isEmpty() {
        return this.amount <= 0 || this.resource.isEmpty();
    }

    public ResourceStack<T> withAmount(int newAmount) {
        return new ResourceStack<T>(this.resource, newAmount);
    }

    public ResourceStack<T> shrink(int amount) {
        return this.withAmount(Math.max(this.amount - amount, 0));
    }

    public ResourceStack<T> grow(int amount) {
        return this.withAmount(this.amount + amount);
    }

    public ResourceStack<T> with(UnaryOperator<T> operator) {
        return new ResourceStack<IResource>((IResource)operator.apply(this.resource), this.amount);
    }
}

