/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import thedarkcolour.exdeorum.block.EBlock;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.config.EConfig;

public abstract class MachineBlock
extends EBlock {
    public MachineBlock(BlockBehaviour.Properties properties, Supplier<? extends BlockEntityType<?>> blockEntityType) {
        super(properties, blockEntityType);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide && type == this.blockEntityType.get() ? new AbstractMachineBlockEntity.ServerTicker() : null;
    }

    protected abstract int getHighlightItemSlot();

    protected abstract MutableComponent getHighlightItemLabel();

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> tooltip, TooltipFlag flag) {
        CustomData customData;
        HolderLookup.Provider lookup = level.registries();
        if (lookup != null && (customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)) != null) {
            CompoundTag nbt = customData.getUnsafe();
            if (nbt.contains("inventory")) {
                ItemStackHandler inventory = new ItemStackHandler();
                inventory.deserializeNBT(lookup, nbt.getCompound("inventory"));
                ItemStack highlightItem = inventory.getStackInSlot(this.getHighlightItemSlot());
                if (!highlightItem.isEmpty()) {
                    tooltip.add((Component)this.getHighlightItemLabel().withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)highlightItem.getDescriptionId())));
                }
            }
            if (nbt.contains("energy")) {
                int energy = nbt.getInt("energy");
                tooltip.add((Component)Component.translatable((String)"gui.exdeorum.energy_label").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"item.exdeorum.watering_can_fluid_display", (Object[])new Object[]{energy, EConfig.SERVER.mechanicalSieveEnergyStorage.get()})).append(" FE"));
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState pState, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && player.isCreative() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)blockEntity;
            if (!machine.inventory.getStackInSlot(this.getHighlightItemSlot()).isEmpty()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)((BlockEntityType)this.blockEntityType.get()), (CompoundTag)machine.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess()));
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
            }
        }
        return super.playerWillDestroy(level, pos, pState, player);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!oldState.is(state.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)blockEntity;
            machine.checkPoweredState(level, pos);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)blockEntity;
            machine.checkPoweredState(level, pos);
        }
    }
}

