/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.blockentity.BarrelBlockEntity;
import thedarkcolour.exdeorum.blockentity.ETankBlockEntity;
import thedarkcolour.exdeorum.blockentity.WaterCrucibleBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.FluidHelper;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.recipe.crucible.CrucibleRecipe;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.EItems;

public abstract class AbstractCrucibleBlockEntity
extends ETankBlockEntity {
    public static final Lazy<HashMap<Item, Block>> MELT_OVERRIDES = Lazy.of(() -> {
        HashMap<Item, Block> map = new HashMap<Item, Block>();
        AbstractCrucibleBlockEntity.addMeltOverrides(map);
        return map;
    });
    public static final int MAX_SOLIDS = 1000;
    public static final int MAX_FLUID_CAPACITY = 4000;
    private final ItemHandler item = new ItemHandler();
    private final FluidHandler tank = new FluidHandler();
    @Nullable
    private Block lastMelted;
    @Nullable
    private Fluid fluid = null;
    private short solids;

    public AbstractCrucibleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("Tank", (Tag)this.tank.writeToNBT(registries, new CompoundTag()));
        if (this.lastMelted != null) {
            nbt.putString("LastMelted", BuiltInRegistries.BLOCK.getKey((Object)this.lastMelted).toString());
        }
        if (this.fluid != null) {
            nbt.putString("Fluid", BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString());
        }
        nbt.putShort("Solids", this.solids);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.tank.readFromNBT(registries, nbt.getCompound("Tank"));
        this.lastMelted = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)nbt.getString("LastMelted")));
        this.fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)nbt.getString("Fluid")));
        this.solids = nbt.getShort("Solids");
        AbstractCrucibleBlockEntity.updateLight(this.level, this.worldPosition, this.fluid);
    }

    public static void updateLight(@Nullable Level level, BlockPos pos, Fluid fluid) {
        AuxiliaryLightManager lightManager;
        if (level != null && (lightManager = level.getAuxLightManager(pos)) != null) {
            lightManager.setLightAt(pos, fluid.getFluidType().getLightLevel());
        }
    }

    @Override
    public void writeVisualData(RegistryFriendlyByteBuf buffer) {
        buffer.writeById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getId(arg_0), (Object)this.tank.getFluid().getFluid());
        buffer.writeVarInt(this.tank.getFluidAmount());
        buffer.writeById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getId(arg_0), (Object)(this.lastMelted != null ? this.lastMelted : Blocks.AIR));
        buffer.writeShort((int)this.solids);
    }

    @Override
    public void readVisualData(RegistryFriendlyByteBuf buffer) {
        Fluid fluid = (Fluid)buffer.readById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).byId(arg_0));
        this.tank.setFluid(new FluidStack(fluid, buffer.readVarInt()));
        Block lastMelted = (Block)buffer.readById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).byId(arg_0));
        this.lastMelted = lastMelted == Blocks.AIR ? null : lastMelted;
        this.solids = buffer.readShort();
        AbstractCrucibleBlockEntity.updateLight(this.level, this.worldPosition, this.tank.getFluid().getFluid());
    }

    @Override
    public void copyVisualData(BlockEntity fromIntegratedServer) {
        if (fromIntegratedServer instanceof AbstractCrucibleBlockEntity) {
            AbstractCrucibleBlockEntity from = (AbstractCrucibleBlockEntity)fromIntegratedServer;
            this.tank.setFluid(from.tank.getFluid().copy());
            this.lastMelted = from.lastMelted;
            this.solids = from.solids;
            AbstractCrucibleBlockEntity.updateLight(this.level, this.worldPosition, this.tank.getFluid().getFluid());
        }
    }

    @Override
    public ItemInteractionResult useItemOn(Level level, Player player, ItemStack stack, InteractionHand hand) {
        ItemStack playerItem = player.getItemInHand(hand);
        if (playerItem.getCapability(Capabilities.FluidHandler.ITEM) != null) {
            return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank) ? ItemInteractionResult.sidedSuccess((boolean)level.isClientSide) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (playerItem.getItem() == Items.GLASS_BOTTLE && this.getType() == EBlockEntities.WATER_CRUCIBLE.get() && ((Boolean)EConfig.SERVER.allowWaterBottleTransfer.get()).booleanValue()) {
            FluidStack fluid = new FluidStack((Fluid)Fluids.WATER, 250);
            if (this.tank.drain(fluid, IFluidHandler.FluidAction.SIMULATE).getAmount() == 250) {
                if (!level.isClientSide) {
                    BarrelBlockEntity.extractWaterBottle((IFluidHandler)this.tank, level, player, playerItem, fluid);
                    this.markUpdated();
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else {
            InsertionResult result = this.canInsertItem(playerItem);
            if (result == InsertionResult.YES ? this.tryMelt(playerItem, player.getAbilities().instabuild ? playerStack -> {} : playerStack -> playerStack.shrink(1)) : result == InsertionResult.FULL) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    protected abstract CrucibleRecipe getRecipe(ItemStack var1);

    private boolean tryMelt(ItemStack item, Consumer<ItemStack> shrinkAction) {
        HashMap melts;
        if (item.isEmpty()) {
            return false;
        }
        Item meltItem = item.getItem();
        CrucibleRecipe recipe = this.getRecipe(item);
        if (recipe == null) {
            this.item.setStackInSlot(0, ItemStack.EMPTY);
            return false;
        }
        if (this.level != null && this.level.isClientSide) {
            return true;
        }
        FluidStack result = recipe.getResult();
        FluidStack contained = this.tank.getFluid();
        shrinkAction.accept(item);
        this.solids = (short)Math.min(this.solids + result.getAmount(), 1000);
        if (contained.isEmpty()) {
            this.fluid = result.getFluid();
            AbstractCrucibleBlockEntity.updateLight(this.level, this.worldPosition, this.fluid);
        }
        if ((melts = (HashMap)MELT_OVERRIDES.get()).containsKey(meltItem)) {
            this.lastMelted = (Block)melts.get(meltItem);
        } else if (meltItem.getClass() == BlockItem.class) {
            this.lastMelted = ((BlockItem)meltItem).getBlock();
        } else if (this.lastMelted == null) {
            this.lastMelted = this.getDefaultMeltBlock();
        }
        this.markUpdated();
        return true;
    }

    private InsertionResult canInsertItem(ItemStack item) {
        FluidStack contained;
        FluidStack result;
        if (item.isEmpty()) {
            return InsertionResult.NO;
        }
        CrucibleRecipe recipe = this.getRecipe(item);
        if (recipe != null && (FluidStack.isSameFluidSameComponents((FluidStack)(result = recipe.getResult()), (FluidStack)(contained = this.tank.getFluid())) || contained.isEmpty())) {
            return result.getAmount() + this.solids <= 1000 ? InsertionResult.YES : InsertionResult.FULL;
        }
        return InsertionResult.NO;
    }

    public abstract int getMeltingRate();

    public int getSolids() {
        return this.solids;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public IItemHandler getItem() {
        return this.item;
    }

    public abstract Block getDefaultMeltBlock();

    @Nullable
    public Block getLastMelted() {
        return this.lastMelted;
    }

    private static void addMeltOverrides(HashMap<Item, Block> overrides) {
        overrides.put(Items.OAK_SAPLING, Blocks.OAK_LEAVES);
        overrides.put(Items.SPRUCE_SAPLING, Blocks.SPRUCE_LEAVES);
        overrides.put(Items.ACACIA_SAPLING, Blocks.ACACIA_LEAVES);
        overrides.put(Items.JUNGLE_SAPLING, Blocks.JUNGLE_LEAVES);
        overrides.put(Items.DARK_OAK_SAPLING, Blocks.DARK_OAK_LEAVES);
        overrides.put(Items.BIRCH_SAPLING, Blocks.BIRCH_LEAVES);
        overrides.put(Items.CHERRY_SAPLING, Blocks.CHERRY_LEAVES);
        overrides.put(Items.MANGROVE_PROPAGULE, Blocks.MANGROVE_LEAVES);
        overrides.put(Items.SWEET_BERRIES, Blocks.SPRUCE_LEAVES);
        overrides.put(Items.GLOW_BERRIES, Blocks.MOSS_BLOCK);
        overrides.put((Item)EItems.GRASS_SEEDS.get(), Blocks.GRASS_BLOCK);
        overrides.put((Item)EItems.MYCELIUM_SPORES.get(), Blocks.MYCELIUM);
        overrides.put((Item)EItems.WARPED_NYLIUM_SPORES.get(), Blocks.WARPED_NYLIUM);
        overrides.put((Item)EItems.CRIMSON_NYLIUM_SPORES.get(), Blocks.CRIMSON_NYLIUM);
        for (Map.Entry sapling : BuiltInRegistries.BLOCK.entrySet()) {
            ResourceLocation key;
            Item item = ((Block)sapling.getValue()).asItem();
            if (overrides.containsKey(item) || !(key = ((ResourceKey)sapling.getKey()).location()).getPath().endsWith("sapling")) continue;
            try {
                overrides.put(item, (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)key.getPath().replace("sapling", "leaves"))));
            }
            catch (Exception exception) {}
        }
    }

    private class ItemHandler
    extends ItemStackHandler {
        private ItemHandler() {
        }

        protected void onContentsChanged(int slot) {
            AbstractCrucibleBlockEntity.this.tryMelt(this.getItem(), item -> this.setStackInSlot(0, ItemStack.EMPTY));
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return AbstractCrucibleBlockEntity.this.canInsertItem(stack) == InsertionResult.YES;
        }

        public ItemStack getItem() {
            return (ItemStack)this.stacks.getFirst();
        }
    }

    private static class FluidHandler
    extends FluidHelper {
        public FluidHandler() {
            super(4000);
        }

        public boolean isFluidValid(FluidStack stack) {
            return false;
        }
    }

    private static enum InsertionResult {
        NO,
        YES,
        FULL;

    }

    public static class Ticker
    implements BlockEntityTicker<AbstractCrucibleBlockEntity> {
        public void tick(Level level, BlockPos pos, BlockState state, AbstractCrucibleBlockEntity crucible) {
            if (!level.isClientSide) {
                FluidHandler tank = crucible.tank;
                if (level.getGameTime() % 10L == 0L) {
                    short delta = (short)Math.min(crucible.solids, crucible.getMeltingRate());
                    if (delta <= 0) {
                        return;
                    }
                    if (tank.getSpace() >= delta) {
                        crucible.solids = (short)(crucible.solids - delta);
                        if (tank.isEmpty()) {
                            if (crucible.fluid != null) {
                                tank.setFluid(new FluidStack(crucible.fluid, (int)delta));
                                AbstractCrucibleBlockEntity.updateLight(level, pos, crucible.fluid);
                            }
                        } else {
                            tank.getFluid().grow((int)delta);
                        }
                        crucible.markUpdated();
                    }
                }
                if (((Boolean)EConfig.SERVER.cruciblesCollectRainWater.get()).booleanValue() && tank.getFluidAmount() < 4000 && crucible instanceof WaterCrucibleBlockEntity && level.isRainingAt(pos.above())) {
                    BarrelBlockEntity.fillRainWater(crucible, tank);
                }
            }
        }
    }
}

